package Lingua::ZH::HanConvert;

use strict;
use warnings;
use utf8;
use v5.6.0;

BEGIN {
    our ($VERSION, @ISA, @EXPORT_OK);
    use Exporter;
    @ISA = qw(Exporter);
    @EXPORT_OK = qw(&trad &simple);
    $VERSION = "0.11";
}

our %trad = ( # string of possible traditional chars for each simplified char

	只=>"只隹祇衹", 台=>"台臺檯颱", 蒙=>"蒙矇濛懞",

	么=>"么麼麽", 准=>"准凖準", 复=>"复復複", 带=>"帶當噹",
	干=>"干乾幹", 系=>"系係繫", 荻=>"荻獲穫", 蚕=>"蚕蠺蠶",

	万=>"万萬", 与=>"与與", 丑=>"丑醜", 业=>"遽業", 丰=>"丰豐",
	为=>"為爲", 乡=>"郷鄉", 了=>"了瞭", 云=>"云雲", 亚=>"亞亜",
	产=>"產産", 亩=>"畆畝", 仆=>"仆僕", 价=>"价價", 众=>"眾衆",
	优=>"优優", 伙=>"伙夥", 体=>"体體", 余=>"余餘", 佣=>"佣傭",
	借=>"借藉", 儿=>"儿兒", 克=>"克剋", 党=>"党黨", 冬=>"冬鼕",
	几=>"几幾", 出=>"出齣", 划=>"划劃", 別=>"別彆", 刮=>"刮颳",
	制=>"制製", 千=>"千韆", 卜=>"卜蔔", 卤=>"鹵滷", 卷=>"卷捲",
	厂=>"厂廠", 历=>"歷曆", 发=>"發髮", 吁=>"吁龥", 合=>"合閣",
	后=>"后後", 向=>"向嚮", 吨=>"吨噸", 听=>"听聽", 启=>"啟啓",
	咸=>"咸鹹", 团=>"團糰", 困=>"困睏", 圣=>"圣聖", 坏=>"坏壞",
	坛=>"壇罎", 坳=>"坳迴", 壳=>"殼殻", 夸=>"夸誇", 姜=>"姜薑",
	宁=>"宁寧", 家=>"家傢", 尽=>"盡儘", 岁=>"歳歲", 岭=>"岭嶺",
	帅=>"師帥", 帘=>"帘簾", 帮=>"幚幫", 庄=>"庄莊", 庆=>"廈慶",
	征=>"征徵", 後=>"後后", 御=>"御禦", 忏=>"忏懺", 怀=>"怀懷",
	怜=>"怜憐", 怼=>"總懟", 惊=>"惊驚", 愿=>"愿願", 才=>"才纔",
	扑=>"扑撲", 扰=>"扰擾", 折=>"折摺", 据=>"据據",斗=>"斗鬥",
	旋=>"旋鏇", 显=>"顰顯", 晒=>"晒曬", 曲=>"曲麯", 朱=>"朱硃",
	朴=>"朴樸", 机=>"机機", 松=>"松鬆", 板=>"板闆", 极=>"极極",
	构=>"构構", 柜=>"柜櫃", 栏=>"欗欄", 栖=>"栖棲", 样=>"様樣",
	气=>"气氣", 汇=>"匯彙", 沈=>"沈瀋", 泞=>"泞濘", 洁=>"洁潔",
	洒=>"洒灑", 洼=>"洼窪", 涂=>"涂塗", 淀=>"淀澱", 漓=>"漓灕",
	灶=>"灶竈", 烂=>"爤爛", 症=>"症癥", 痒=>"痒癢", 确=>"确確",
	离=>"离離", 秋=>"秋鞦", 种=>"种種", 筑=>"筑築", 签=>"籤簽",
	篱=>"篱籬", 累=>"累纍", 纤=>"縴纖", 网=>"网網", 肮=>"肮骯",
	胜=>"胜勝", 胡=>"胡鬍", 脏=>"臟髒", 腊=>"腊臘", 致=>"致緻",
	舍=>"舍捨", 芸=>"芸蕓", 苏=>"蘇囌", 苹=>"苹蘋", 范=>"范範",
	茧=>"茧繭", 荐=>"荐薦", 蔑=>"蔑衊", 虫=>"虫蟲", 虮=>"虮蟣",
	蜡=>"蜡蠟", 表=>"表錶", 触=>"触觸", 谷=>"谷穀", 赃=>"贓贜",
	赶=>"赶趕", 踊=>"踊踴", 車=>"車车", 辟=>"辟闢", 还=>"邃還",
	适=>"适適", 逃=>"逃適", 郁=>"郁鬱", 酝=>"醞醖", 里=>"里裏",
	钟=>"鐘鍾", 隩=>"隩随", 霉=>"霉黴", 面=>"面麵", 须=>"鬚須",
	飛=>"飛飞", 鸡=>"雞鷄", 龜=>"龜龟", 

	专=>"專", 丛=>"叢", 东=>"東", 丝=>"絲", 两=>"兩", 严=>"嚴",
	丧=>"喪", 个=>"個", 临=>"臨", 丽=>"麗", 举=>"舉", 义=>"義",
	乌=>"烏", 乐=>"樂", 乔=>"喬", 习=>"習", 书=>"書", 买=>"買",
	乱=>"亂", 争=>"爭", 亏=>"虧", 亲=>"親", 亵=>"褻", 亿=>"億",
	仅=>"僅", 从=>"從", 仑=>"侖", 仓=>"倉", 仪=>"儀", 们=>"們",
	会=>"會", 伛=>"傴", 伞=>"傘", 伟=>"偉", 传=>"傳", 伤=>"傷",
	伥=>"倀", 伦=>"倫", 伧=>"傖", 伪=>"僞", 伫=>"佇", 佥=>"僉",
	侠=>"俠", 侥=>"僥", 侦=>"偵", 侧=>"側", 侨=>"僑", 侩=>"儈",
	侪=>"儕", 侬=>"儂", 俦=>"儔", 俨=>"儼", 俩=>"倆", 俪=>"儷",
	俭=>"儉", 债=>"債", 倾=>"傾", 偻=>"僂", 偾=>"僨", 偿=>"償",
	傥=>"儻", 傧=>"儐", 储=>"儲", 傩=>"儺", 兰=>"蘭", 关=>"關",
	兴=>"興", 养=>"養", 兽=>"獸", 冁=>"囅", 冈=>"岡", 写=>"寫",
	军=>"軍", 农=>"農", 冯=>"馮", 冲=>"衝", 冻=>"凍", 净=>"凈",
	凤=>"鳳", 凫=>"鳬", 凭=>"憑", 凯=>"凱", 击=>"擊", 凿=>"鑿",
	刅=>"辦", 刍=>"芻", 刘=>"劉", 则=>"則", 刚=>"剛", 创=>"創",
	刭=>"剄", 刽=>"劊", 刿=>"劌", 剀=>"剴", 剂=>"劑", 剐=>"剮",
	剑=>"劍", 剧=>"劇", 劝=>"勸", 办=>"辦", 务=>"務", 劢=>"勱",
	动=>"動", 励=>"勵", 劲=>"勁", 劳=>"勞", 势=>"勢", 勋=>"勛",
	匦=>"匭", 匮=>"匱", 区=>"區", 医=>"醫", 华=>"華", 协=>"協",
	单=>"單", 卖=>"賣", 卢=>"盧", 卫=>"衛", 厅=>"廳", 厉=>"厲",
	压=>"壓", 厌=>"厭", 厍=>"厙", 厕=>"厠", 厣=>"厴", 县=>"縣",
	参=>"參", 双=>"雙", 变=>"變", 叠=>"疊", 叶=>"葉", 号=>"號",
	叹=>"嘆", 叽=>"嘰", 吓=>"嚇", 吗=>"嗎", 呒=>"嘸", 呓=>"囈",
	呕=>"嘔", 呖=>"嚦", 呗=>"唄", 员=>"員", 呙=>"咼", 呛=>"嗆",
	呜=>"嗚", 咙=>"嚨", 咛=>"嚀", 咝=>"噝", 响=>"響", 哑=>"啞",
	哒=>"噠", 哓=>"嘵", 哔=>"嗶", 哕=>"噦", 哗=>"嘩", 哙=>"噲",
	哜=>"嚌", 哝=>"噥", 哟=>"喲", 唛=>"嘜", 唠=>"嘮", 唢=>"嗩",
	唤=>"喚", 啧=>"嘖", 啬=>"嗇", 啭=>"囀", 啮=>"嚙", 啸=>"嘯",
	喷=>"噴", 喽=>"嘍", 喾=>"嚳", 嗫=>"囁", 嗳=>"噯", 嘤=>"嚶",
	嘱=>"囑", 噜=>"嚕", 嚣=>"囂", 园=>"園", 围=>"圍", 囵=>"圇",
	国=>"國", 图=>"圖", 圆=>"圓", 圹=>"壙", 场=>"場", 块=>"塊",
	坚=>"堅", 坜=>"壢", 坝=>"壩", 坞=>"塢", 坟=>"墳", 坠=>"墜",
	垄=>"壟", 垅=>"壠", 垆=>"壚", 垒=>"壘", 垦=>"墾", 垩=>"堊",
	垫=>"墊", 垭=>"埡", 垲=>"塏", 垴=>"堖", 埘=>"塒", 埙=>"塤",
	埚=>"堝", 堑=>"塹", 堕=>"墮", 墙=>"墻", 壮=>"壯", 声=>"聲",
	壶=>"壺", 壸=>"壹", 处=>"處", 备=>"備", 头=>"頭", 夹=>"夾",
	夺=>"奪", 奁=>"奩", 奂=>"奐", 奋=>"奮", 奖=>"奬", 妆=>"妝",
	妇=>"婦", 妈=>"媽", 妩=>"嫵", 妪=>"嫗", 妫=>"嬀", 娄=>"婁",
	娅=>"婭", 娆=>"嬈", 娇=>"嬌", 娈=>"孌", 娲=>"媧", 娴=>"嫻",
	婴=>"嬰", 婵=>"嬋", 婶=>"嬸", 嫒=>"嬡", 嫔=>"嬪", 嫱=>"嬙",
	孙=>"孫", 学=>"學", 孪=>"孿", 宝=>"寶", 实=>"實", 宠=>"寵",
	审=>"審", 宪=>"憲", 宽=>"寬", 宾=>"賓", 寝=>"寢", 对=>"對",
	寻=>"尋", 导=>"導", 寿=>"壽", 将=>"將", 尔=>"爾", 尘=>"塵",
	尝=>"嘗", 尧=>"堯", 尴=>"尷", 层=>"層", 属=>"屬", 屡=>"屢",
	屦=>"屨", 屿=>"嶼", 岂=>"豈", 岖=>"嶇", 岗=>"崗", 岘=>"峴",
	岚=>"嵐", 岛=>"島", 岽=>"崬", 岿=>"巋", 峄=>"嶧", 峡=>"峽",
	峤=>"嶠", 峥=>"崢", 峦=>"巒", 崂=>"嶗", 崃=>"崍", 崭=>"嶄",
	嵘=>"嶸", 嵝=>"嶁", 巅=>"巔", 巩=>"鞏", 巯=>"巰", 币=>"幣",
	师=>"師", 帏=>"幃", 帐=>"帳", 帜=>"幟", 帧=>"幀", 帱=>"幬",
	帻=>"幘", 帼=>"幗", 幞=>"膽", 广=>"廣", 庐=>"廬", 庑=>"廡",
	库=>"庫", 应=>"應", 庙=>"廟", 庞=>"龐", 废=>"廢", 开=>"開",
	弃=>"棄", 张=>"張", 弥=>"彌", 弪=>"弳", 弯=>"彎", 弹=>"彈",
	归=>"歸", 当=>"當", 录=>"録", 彻=>"徹", 径=>"徑", 徕=>"徠",
	忆=>"憶", 忧=>"憂", 忾=>"愾", 态=>"態", 怂=>"慫", 怃=>"憮",
	怄=>"慪", 怅=>"悵", 怆=>"愴", 总=>"總", 怿=>"懌", 恋=>"戀",
	恳=>"懇", 恶=>"惡", 恸=>"慟", 恹=>"懨", 恺=>"愷", 恻=>"惻",
	恼=>"惱", 恽=>"惲", 悫=>"慤", 悬=>"懸", 悭=>"慳", 悯=>"憫",
	惧=>"懼", 惨=>"慘", 惩=>"懲", 惫=>"憊", 惬=>"愜", 惭=>"慚",
	惮=>"憚", 惯=>"慣", 愤=>"憤", 愦=>"憒", 慑=>"懾", 懑=>"懣",
	懒=>"懶", 戆=>"戇", 戋=>"戔", 戏=>"戲", 戗=>"戧", 战=>"戰",
	戬=>"戩", 执=>"執", 扩=>"擴", 扪=>"捫", 扫=>"掃", 扬=>"揚",
	抚=>"撫", 抟=>"摶", 抠=>"摳", 抡=>"掄", 抢=>"搶", 护=>"護",
	报=>"報", 担=>"擔", 拟=>"擬", 拢=>"攏", 拣=>"揀", 拥=>"擁",
	拦=>"攔", 拧=>"擰", 拨=>"撥", 择=>"擇", 挚=>"摯", 挛=>"攣",
	挝=>"撾", 挞=>"撻", 挟=>"挾", 挠=>"撓", 挡=>"擋", 挢=>"撟",
	挣=>"掙", 挤=>"擠", 挥=>"揮", 捞=>"撈", 损=>"損", 捡=>"撿",
	换=>"換", 捣=>"搗", 掳=>"擄", 掴=>"摑", 掷=>"擲", 掸=>"撣",
	掺=>"摻", 掼=>"摜", 揽=>"攬", 揿=>"撳", 搀=>"攙", 搁=>"擱",
	搂=>"摟", 搅=>"攪", 摄=>"攝", 摅=>"攄", 摆=>"擺", 摈=>"擯",
	摊=>"攤", 撄=>"攖", 撵=>"攆", 撷=>"擷", 撸=>"擼", 撺=>"攛",
	擞=>"擻", 攒=>"攢", 敌=>"敵", 敛=>"斂", 数=>"數", 斋=>"齋",
	斓=>"斕", 斩=>"斬", 断=>"斷", 无=>"無", 旧=>"舊", 时=>"時",
	旷=>"曠", 昙=>"曇", 昼=>"晝", 晋=>"晉", 晓=>"曉", 晔=>"曄",
	晕=>"暈", 晖=>"暉", 暂=>"暫", 暧=>"曖", 术=>"術", 杀=>"殺",
	杂=>"雜", 权=>"權", 条=>"條", 来=>"來", 杨=>"楊", 杩=>"榪",
	枞=>"樅", 枢=>"樞", 枣=>"棗", 枥=>"櫪", 枧=>"梘", 枨=>"棖",
	枪=>"槍", 枫=>"楓", 枭=>"梟", 柠=>"檸", 柽=>"檉", 栆=>"棗",
	标=>"標", 栈=>"棧", 栉=>"櫛", 栊=>"櫳", 栋=>"棟", 栌=>"櫨",
	栎=>"櫟", 树=>"樹", 栾=>"欒", 桠=>"椏", 桡=>"橈", 桢=>"楨",
	档=>"檔", 桤=>"榿", 桥=>"橋", 桦=>"樺", 桧=>"檜", 桨=>"槳",
	桩=>"樁", 梦=>"夢", 检=>"檢", 棂=>"欞", 椟=>"櫝", 椠=>"槧",
	椤=>"欏", 椭=>"橢", 楼=>"樓", 榄=>"欖", 榇=>"櫬", 榈=>"櫚",
	榉=>"櫸", 槛=>"檻", 槟=>"檳", 槠=>"櫧", 樯=>"檣", 樱=>"櫻",
	橹=>"櫓", 橼=>"櫞", 欢=>"歡", 欤=>"歟", 欧=>"歐", 歼=>"殲",
	殇=>"殤", 残=>"殘", 殒=>"殞", 殓=>"殮", 殚=>"殫", 殡=>"殯",
	殴=>"毆", 毂=>"轂", 毕=>"畢", 毙=>"斃", 毡=>"氈", 毵=>"毿",
	氇=>"氌", 氢=>"氫", 氩=>"氬", 汉=>"漢", 汤=>"湯", 沟=>"溝",
	沣=>"灃", 沤=>"漚", 沥=>"瀝", 沦=>"淪", 沧=>"滄", 沩=>"潙",
	沪=>"滬", 泶=>"澩", 泷=>"瀧", 泸=>"瀘", 泺=>"濼", 泻=>"瀉",
	泼=>"潑", 泽=>"澤", 泾=>"涇", 浃=>"浹", 浅=>"淺", 浆=>"漿",
	浇=>"澆", 浈=>"湞", 浊=>"濁", 测=>"測", 浍=>"澮", 济=>"濟",
	浏=>"瀏", 浑=>"渾", 浒=>"滸", 浓=>"濃", 浔=>"潯", 涛=>"濤",
	涝=>"澇", 涞=>"淶", 涟=>"漣", 涠=>"潿", 涡=>"渦", 涣=>"渙",
	涤=>"滌", 润=>"潤", 涧=>"澗", 涨=>"漲", 涩=>"澀", 渊=>"淵",
	渍=>"漬", 渎=>"瀆", 渐=>"漸", 渑=>"澠", 渔=>"漁", 渖=>"瀋",
	渗=>"滲", 湾=>"灣", 湿=>"濕", 溃=>"潰", 溅=>"濺", 滗=>"潷",
	滞=>"滯", 滟=>"灧", 滠=>"灄", 满=>"滿", 滢=>"瀅", 滤=>"濾",
	滥=>"濫", 滦=>"灤", 滨=>"濱", 滩=>"灘", 潆=>"瀠", 潇=>"瀟",
	潋=>"瀲", 潍=>"濰", 潜=>"潛", 澜=>"瀾", 濑=>"瀨", 濒=>"瀕",
	灏=>"灝", 灭=>"滅", 灯=>"燈", 灵=>"靈", 灿=>"燦", 炀=>"煬",
	炉=>"爐", 炜=>"煒", 炝=>"熗", 点=>"點", 炼=>"煉", 炽=>"熾",
	烁=>"爍", 烃=>"烴", 烛=>"燭", 烦=>"煩", 烧=>"燒", 烨=>"燁",
	烩=>"燴", 烫=>"燙", 烬=>"燼", 热=>"熱", 焕=>"煥", 焖=>"燜",
	焘=>"燾", 爱=>"愛", 爷=>"爺", 牍=>"牘", 牵=>"牽", 牺=>"犧",
	犊=>"犢", 状=>"狀", 犷=>"獷", 犸=>"獁", 犹=>"猶", 狈=>"狽",
	狞=>"獰", 独=>"獨", 狭=>"狹", 狮=>"獅", 狯=>"獪", 狰=>"猙",
	狱=>"獄", 狲=>"猻", 猃=>"獫", 猎=>"獵", 猕=>"獼", 猡=>"玀",
	献=>"獻", 獭=>"獺", 玑=>"璣", 玛=>"瑪", 玮=>"瑋", 环=>"環",
	现=>"現", 玺=>"璽", 珑=>"瓏", 珲=>"琿", 琏=>"璉", 琐=>"瑣",
	琼=>"瓊", 瑷=>"璦", 璎=>"瓔", 瓒=>"瓚", 瓯=>"甌", 电=>"電",
	画=>"畫", 畅=>"暢", 畴=>"疇", 疖=>"癤", 疗=>"療", 疟=>"瘧",
	疠=>"癘", 疡=>"瘍", 疬=>"癧", 疮=>"瘡", 疯=>"瘋", 痈=>"癰",
	痉=>"痙", 痖=>"瘂", 痨=>"癆", 痪=>"瘓", 痫=>"癇", 瘅=>"癉",
	瘗=>"瘞", 瘘=>"瘻", 瘪=>"癟", 瘫=>"癱", 瘾=>"癮", 瘿=>"癭",
	癞=>"癩", 癣=>"癬", 癫=>"癲", 皑=>"皚", 皱=>"皺", 皲=>"皸",
	盏=>"盞", 盐=>"鹽", 监=>"監", 盖=>"蓋", 盘=>"盤", 眍=>"瞘",
	睁=>"睜", 睐=>"睞", 睑=>"瞼", 瞒=>"瞞", 瞩=>"矚", 矫=>"矯",
	矶=>"磯", 矾=>"礬", 矿=>"礦", 砀=>"碭", 码=>"碼", 砖=>"磚",
	砗=>"硨", 砚=>"硯", 砜=>"碸", 砺=>"礪", 砻=>"礱", 砾=>"礫",
	础=>"礎", 硕=>"碩", 硖=>"硤", 硗=>"磽", 硷=>"鹼", 碍=>"礙",
	碛=>"磧", 碜=>"磣", 礼=>"禮", 祢=>"禰", 祯=>"禎", 祷=>"禱",
	祸=>"禍", 禅=>"禪", 积=>"積", 称=>"稱", 秽=>"穢", 稣=>"穌",
	稳=>"穩", 穑=>"穡", 穷=>"窮", 窃=>"竊", 窍=>"竅", 窜=>"竄",
	窝=>"窩", 窥=>"窺", 窦=>"竇", 窭=>"窶", 竖=>"竪", 竞=>"競",
	笃=>"篤", 笔=>"筆", 笕=>"筧", 笺=>"箋", 笼=>"籠", 笾=>"籩",
	筚=>"篳", 筛=>"篩", 筝=>"箏", 筹=>"籌", 简=>"簡", 箦=>"簀",
	箧=>"篋", 箨=>"籜", 箩=>"籮", 箪=>"簞", 箫=>"簫", 篑=>"簣",
	篓=>"簍", 篮=>"籃", 簖=>"籪", 籁=>"籟", 籴=>"糴", 类=>"類",
	粜=>"糶", 粝=>"糲", 粪=>"糞", 粮=>"糧", 糁=>"糝", 紧=>"緊",
	絷=>"縶", 纟=>"糹", 纠=>"糾", 纡=>"紆", 红=>"紅", 纣=>"紂",
	纥=>"紇", 约=>"約", 级=>"級", 纨=>"紈", 纩=>"纊", 纪=>"紀",
	纫=>"紉", 纬=>"緯", 纭=>"紜", 纯=>"純", 纰=>"紕", 纱=>"紗",
	纲=>"綱", 纳=>"納", 纵=>"縱", 纶=>"綸", 纷=>"紛", 纸=>"紙",
	纹=>"紋", 纺=>"紡", 纽=>"紐", 纾=>"紓", 线=>"綫", 绀=>"紺",
	绁=>"紲", 绂=>"紱", 练=>"練", 组=>"組", 绅=>"紳", 细=>"細",
	织=>"織", 终=>"終", 绉=>"縐", 绊=>"絆", 绋=>"紼", 绌=>"絀",
	绍=>"紹", 绎=>"繹", 经=>"經", 绐=>"紿", 绑=>"綁", 绒=>"絨",
	结=>"結", 绔=>"絝", 绕=>"繞", 绗=>"絎", 绘=>"繪", 给=>"給",
	绚=>"絢", 绛=>"絳", 络=>"絡", 绝=>"絶", 绞=>"絞", 统=>"統",
	绠=>"綆", 绡=>"綃", 绢=>"絹", 绣=>"綉", 绥=>"綏", 绦=>"縧",
	继=>"繼", 绨=>"綈", 绩=>"績", 绪=>"緒", 绫=>"綾", 续=>"續",
	绮=>"綺", 绯=>"緋", 绰=>"綽", 绱=>"緔", 绲=>"緄", 绳=>"繩",
	维=>"維", 绵=>"綿", 绶=>"綬", 绷=>"綳", 绸=>"綢", 绺=>"綹",
	绻=>"綣", 综=>"綜", 绽=>"綻", 绾=>"綰", 绿=>"緑", 缀=>"綴",
	缁=>"緇", 缂=>"緙", 缃=>"緗", 缄=>"緘", 缅=>"緬", 缆=>"纜",
	缇=>"緹", 缈=>"緲", 缉=>"緝", 缋=>"繢", 缌=>"緦", 缍=>"綞",
	缎=>"緞", 缏=>"緶", 缑=>"緱", 缒=>"縋", 缓=>"緩", 缔=>"締",
	缕=>"縷", 编=>"編", 缗=>"緡", 缘=>"緣", 缙=>"縉", 缚=>"縛",
	缛=>"縟", 缜=>"縝", 缝=>"縫", 缟=>"縞", 缠=>"纏", 缡=>"縭",
	缢=>"縊", 缣=>"縑", 缤=>"繽", 缥=>"縹", 缦=>"縵", 缧=>"縲",
	缨=>"纓", 缩=>"縮", 缪=>"繆", 缫=>"繅", 缬=>"纈", 缭=>"繚",
	缮=>"繕", 缯=>"繒", 缰=>"繮", 缱=>"繾", 缲=>"繰", 缳=>"繯",
	缴=>"繳", 缵=>"纘", 罂=>"罌", 罗=>"羅", 罚=>"罰", 罢=>"罷",
	罴=>"羆", 羁=>"羈", 羟=>"羥", 翘=>"翹", 耢=>"耮", 耧=>"耬",
	耸=>"聳", 聂=>"聶", 聋=>"聾", 职=>"職", 聍=>"聹", 联=>"聯",
	聩=>"聵", 聪=>"聰", 肃=>"肅", 肠=>"腸", 肤=>"膚", 肾=>"腎",
	肿=>"腫", 胀=>"脹", 胁=>"脅", 胆=>"膽", 胧=>"朧", 胨=>"腖",
	胪=>"臚", 胫=>"脛", 胶=>"膠", 脍=>"膾", 脐=>"臍", 脑=>"腦",
	脓=>"膿", 脔=>"臠", 脶=>"腡", 脸=>"臉", 腻=>"膩", 腾=>"騰",
	膑=>"臏", 舆=>"輿", 舎=>"捨", 舣=>"艤", 舰=>"艦", 舱=>"艙",
	舻=>"艫", 艰=>"艱", 艳=>"艷", 艺=>"藝", 节=>"節", 芗=>"薌",
	芜=>"蕪", 芦=>"蘆", 苁=>"蓯", 苇=>"葦", 苈=>"藶", 苋=>"莧",
	苌=>"萇", 苍=>"蒼", 苎=>"苧", 茎=>"莖", 茏=>"蘢", 茑=>"蔦",
	茔=>"塋", 茕=>"煢", 荚=>"莢", 荛=>"蕘", 荜=>"蓽", 荞=>"蕎",
	荟=>"薈", 荠=>"薺", 荡=>"蕩", 荣=>"榮", 荤=>"葷", 荥=>"滎",
	荦=>"犖", 荧=>"熒", 荨=>"蕁", 荩=>"藎", 荪=>"蓀", 荫=>"蔭",
	荬=>"蕒", 荭=>"葒", 荮=>"葤", 药=>"藥", 莱=>"萊", 莲=>"蓮",
	莳=>"蒔", 莴=>"萵", 莶=>"薟", 获=>"獲", 莸=>"蕕", 莹=>"瑩",
	莺=>"鶯", 莼=>"蒓", 萝=>"蘿", 萤=>"螢", 营=>"營", 萦=>"縈",
	萧=>"蕭", 萨=>"薩", 蒇=>"蕆", 蒉=>"蕢", 蒋=>"蔣", 蒌=>"蔞",
	蓝=>"藍", 蓟=>"薊", 蓠=>"蘺", 蓣=>"蕷", 蓥=>"鎣", 蓦=>"驀",
	蔷=>"薔", 蔹=>"蘞", 蔺=>"藺", 蔼=>"藹", 蕲=>"蘄", 蕴=>"藴",
	薮=>"藪", 藓=>"蘚", 虏=>"虜", 虑=>"慮", 虽=>"雖", 虾=>"蝦",
	虿=>"蠆", 蚀=>"蝕", 蚁=>"蟻", 蚂=>"螞", 蚬=>"蜆", 蛊=>"蠱",
	蛎=>"蠣", 蛏=>"蟶", 蛮=>"蠻", 蛰=>"蟄", 蛱=>"蛺", 蛲=>"蟯",
	蛳=>"螄", 蛴=>"蠐", 蜗=>"蝸", 蝇=>"蠅", 蝈=>"蟈", 蝉=>"蟬",
	蝼=>"螻", 蝾=>"蠑", 螨=>"蟎", 衅=>"釁", 衔=>"銜", 补=>"補",
	衬=>"襯", 袄=>"襖", 袅=>"裊", 袜=>"襪", 袭=>"襲", 装=>"裝",
	裆=>"襠", 裢=>"褳", 裣=>"襝", 裤=>"褲", 裥=>"襇", 褛=>"褸",
	褴=>"襤", 见=>"見", 观=>"觀", 规=>"規", 觅=>"覓", 视=>"視",
	觇=>"覘", 览=>"覽", 觉=>"覺", 觊=>"覬", 觋=>"覡", 觌=>"覿",
	觎=>"覦", 觏=>"覯", 觐=>"覲", 觑=>"覷", 觞=>"觴", 觯=>"觶",
	誉=>"譽", 誊=>"謄", 讠=>"訁", 计=>"計", 订=>"訂", 讣=>"訃",
	认=>"認", 讥=>"譏", 讦=>"訐", 讧=>"訌", 讨=>"討", 让=>"讓",
	讪=>"訕", 讫=>"訖", 训=>"訓", 议=>"議", 讯=>"訊", 记=>"記",
	讲=>"講", 讳=>"諱", 讴=>"謳", 讵=>"詎", 讶=>"訝", 讷=>"訥",
	许=>"許", 讹=>"訛", 论=>"論", 讼=>"訟", 讽=>"諷", 设=>"設",
	访=>"訪", 诀=>"訣", 证=>"證", 诂=>"詁", 诃=>"訶", 评=>"評",
	诅=>"詛", 识=>"識", 诈=>"詐", 诉=>"訴", 诊=>"診", 诋=>"詆",
	诌=>"謅", 词=>"詞", 诎=>"詘", 诏=>"詔", 译=>"譯", 诒=>"詒",
	诓=>"誆", 诔=>"誄", 试=>"試", 诖=>"詿", 诗=>"詩", 诘=>"詰",
	诙=>"詼", 诚=>"誠", 诛=>"誅", 诜=>"詵", 话=>"話", 诞=>"誕",
	诟=>"詬", 诠=>"詮", 诡=>"詭", 询=>"詢", 诣=>"詣", 诤=>"諍",
	该=>"該", 详=>"詳", 诧=>"詫", 诨=>"諢", 诩=>"詡", 诫=>"誡",
	诬=>"誣", 语=>"語", 诮=>"誚", 误=>"誤", 诰=>"誥", 诱=>"誘",
	诲=>"誨", 诳=>"誑", 说=>"説", 诵=>"誦", 诶=>"誒", 请=>"請",
	诸=>"諸", 诹=>"諏", 诺=>"諾", 读=>"讀", 诼=>"諑", 诽=>"誹",
	课=>"課", 诿=>"諉", 谀=>"諛", 谁=>"誰", 谂=>"諗", 调=>"調",
	谄=>"諂", 谅=>"諒", 谆=>"諄", 谇=>"誶", 谈=>"談", 谊=>"誼",
	谋=>"謀", 谌=>"諶", 谍=>"諜", 谎=>"謊", 谏=>"諫", 谐=>"諧",
	谑=>"謔", 谒=>"謁", 谓=>"謂", 谔=>"諤", 谕=>"諭", 谖=>"諼",
	谗=>"讒", 谘=>"諮", 谙=>"諳", 谚=>"諺", 谛=>"諦", 谜=>"謎",
	谝=>"諞", 谟=>"謨", 谠=>"讜", 谡=>"謖", 谢=>"謝", 谣=>"謡",
	谤=>"謗", 谥=>"謚", 谦=>"謙", 谧=>"謐", 谨=>"謹", 谩=>"謾",
	谪=>"謫", 谫=>"謭", 谬=>"謬", 谭=>"譚", 谮=>"譖", 谯=>"譙",
	谰=>"讕", 谱=>"譜", 谲=>"譎", 谳=>"讞", 谴=>"譴", 谵=>"譫",
	谶=>"讖", 贝=>"貝", 贞=>"貞", 负=>"負", 贡=>"貢", 财=>"財",
	责=>"責", 贤=>"賢", 败=>"敗", 账=>"賬", 货=>"貨", 质=>"質",
	贩=>"販", 贪=>"貪", 贫=>"貧", 贬=>"貶", 购=>"購", 贮=>"貯",
	贯=>"貫", 贰=>"貳", 贱=>"賤", 贲=>"賁", 贳=>"貰", 贴=>"貼",
	贵=>"貴", 贶=>"貺", 贷=>"貸", 贸=>"貿", 费=>"費", 贺=>"賀",
	贻=>"貽", 贼=>"賊", 贽=>"贄", 贾=>"賈", 贿=>"賄", 赀=>"貲",
	赁=>"賃", 赂=>"賂", 资=>"資", 赅=>"賅", 赆=>"贐", 赇=>"賕",
	赈=>"賑", 赉=>"賚", 赊=>"賒", 赋=>"賦", 赌=>"賭", 赍=>"賫",
	赎=>"贖", 赏=>"賞", 赐=>"賜", 赓=>"賡", 赔=>"賠", 赕=>"賧",
	赖=>"賴", 赘=>"贅", 赙=>"賻", 赚=>"賺", 赛=>"賽", 赜=>"賾",
	赝=>"贋", 赞=>"贊", 赠=>"贈", 赡=>"贍", 赢=>"贏", 赣=>"贛",
	赵=>"趙", 趋=>"趨", 趱=>"趲", 趸=>"躉", 跃=>"躍", 跄=>"蹌",
	跞=>"躒", 践=>"踐", 跷=>"蹺", 跸=>"蹕", 跹=>"躚", 跻=>"躋",
	踌=>"躊", 踬=>"躓", 踯=>"躑", 蹑=>"躡", 蹒=>"蹣", 蹿=>"躥",
	躏=>"躪", 躜=>"躦", 躯=>"軀", 车=>"車", 轧=>"軋", 轨=>"軌",
	轩=>"軒", 轫=>"軔", 转=>"轉", 轭=>"軛", 轮=>"輪", 软=>"軟",
	轰=>"轟", 轱=>"軲", 轲=>"軻", 轳=>"轤", 轴=>"軸", 轵=>"軹",
	轶=>"軼", 轷=>"軤", 轸=>"軫", 轹=>"轢", 轺=>"軺", 轻=>"輕",
	轼=>"軾", 载=>"載", 轾=>"輊", 轿=>"轎", 辁=>"輇", 辂=>"輅",
	较=>"較", 辄=>"輒", 辅=>"輔", 辆=>"輛", 辇=>"輦", 辈=>"輩",
	辉=>"輝", 辊=>"輥", 辋=>"輞", 辍=>"輟", 辎=>"輜", 辏=>"輳",
	辐=>"輻", 辑=>"輯", 输=>"輸", 辔=>"轡", 辕=>"轅", 辖=>"轄",
	辗=>"輾", 辘=>"轆", 辙=>"轍", 辚=>"轔", 辞=>"辭", 辩=>"辯",
	辫=>"辮", 边=>"邊", 辺=>"邊", 辽=>"遼", 达=>"達", 迁=>"遷",
	过=>"過", 迈=>"邁", 运=>"運", 这=>"這", 进=>"進", 远=>"遠",
	违=>"違", 连=>"連", 迟=>"遲", 迩=>"邇", 迳=>"逕", 选=>"選",
	逊=>"遜", 递=>"遞", 逦=>"邐", 逻=>"邏", 遗=>"遺", 邓=>"鄧",
	邝=>"鄺", 邬=>"鄔", 邮=>"郵", 邹=>"鄒", 邺=>"鄴", 邻=>"鄰",
	郏=>"郟", 郐=>"鄶", 郑=>"鄭", 郓=>"鄆", 郦=>"酈", 郧=>"鄖",
	郸=>"鄲", 酱=>"醬", 酽=>"釅", 酾=>"釃", 酿=>"釀", 释=>"釋",
	鉴=>"鑒", 銮=>"鑾", 錾=>"鏨", 钅=>"釒", 钆=>"釓", 钇=>"釔",
	针=>"針", 钉=>"釘", 钊=>"釗", 钋=>"釙", 钌=>"釕", 钍=>"釷",
	钎=>"釺", 钏=>"釧", 钐=>"釤", 钒=>"釩", 钓=>"釣", 钔=>"鍆",
	钕=>"釹", 钗=>"釵", 钙=>"鈣", 钚=>"鈈", 钛=>"鈦", 钜=>"鉅",
	钝=>"鈍", 钞=>"鈔", 钠=>"鈉", 钡=>"鋇", 钢=>"鋼", 钣=>"鈑",
	钤=>"鈐", 钥=>"鑰", 钦=>"欽", 钧=>"鈞", 钨=>"鎢", 钩=>"鈎",
	钪=>"鈧", 钫=>"鈁", 钬=>"鈥", 钭=>"鈄", 钮=>"鈕", 钯=>"鈀",
	钰=>"鈺", 钱=>"錢", 钲=>"鉦", 钳=>"鉗", 钴=>"鈷", 钵=>"鉢",
	钶=>"鈳", 钷=>"鉕", 钸=>"鈽", 钹=>"鈸", 钺=>"鉞", 钻=>"鑽",
	钼=>"鉬", 钽=>"鉭", 钾=>"鉀", 钿=>"鈿", 铀=>"鈾", 铁=>"鐵",
	铂=>"鉑", 铃=>"鈴", 铄=>"鑠", 铅=>"鉛", 铆=>"鉚", 铈=>"鈰",
	铉=>"鉉", 铊=>"鉈", 铋=>"鉍", 铌=>"鈮", 铍=>"鈹", 铎=>"鐸",
	铐=>"銬", 铑=>"銠", 铒=>"鉺", 铕=>"銪", 铖=>"鋮", 铗=>"鋏",
	铘=>"鋣", 铙=>"鐃", 铛=>"鐺", 铜=>"銅", 铝=>"鋁", 铞=>"銱",
	铟=>"銦", 铠=>"鎧", 铡=>"鍘", 铢=>"銖", 铣=>"銑", 铤=>"鋌",
	铥=>"銩", 铧=>"鏵", 铨=>"銓", 铩=>"鎩", 铪=>"鉿", 铫=>"銚",
	铬=>"鉻", 铭=>"銘", 铮=>"錚", 铯=>"銫", 铰=>"鉸", 铱=>"銥",
	铲=>"鏟", 铳=>"銃", 铴=>"鐋", 铵=>"銨", 银=>"銀", 铷=>"銣",
	铸=>"鑄", 铹=>"鐒", 铺=>"鋪", 铼=>"錸", 铽=>"鋱", 链=>"鏈",
	铿=>"鏗", 销=>"銷", 锁=>"鎖", 锂=>"鋰", 锃=>"鋥", 锄=>"鋤",
	锅=>"鍋", 锆=>"鋯", 锇=>"鋨", 锈=>"銹", 锉=>"銼", 锊=>"鋝",
	锋=>"鋒", 锌=>"鋅", 锍=>"鋶", 锎=>"鐦", 锏=>"鐧", 锐=>"鋭",
	锑=>"銻", 锒=>"鋃", 锓=>"鋟", 锔=>"鋦", 锕=>"錒", 锖=>"錆",
	锗=>"鍺", 锘=>"鍩", 错=>"錯", 锚=>"錨", 锛=>"錛", 锝=>"鍀",
	锞=>"錁", 锟=>"錕", 锡=>"錫", 锢=>"錮", 锣=>"鑼", 锤=>"錘",
	锥=>"錐", 锦=>"錦", 锨=>"鍁", 锩=>"錈", 锪=>"鍃", 锫=>"錇",
	锬=>"錟", 锭=>"錠", 键=>"鍵", 锯=>"鋸", 锰=>"錳", 锱=>"錙",
	锲=>"鍥", 锴=>"鍇", 锵=>"鏘", 锶=>"鍶", 锷=>"鍔", 锸=>"鍤",
	锹=>"鍬", 锺=>"鍾", 锻=>"鍛", 锼=>"鎪", 锾=>"鍰", 锿=>"鎄",
	镀=>"鍍", 镁=>"鎂", 镂=>"鏤", 镄=>"鐨", 镅=>"鎇", 镆=>"鏌",
	镇=>"鎮", 镉=>"鎘", 镊=>"鑷", 镌=>"鎸", 镍=>"鎳", 镎=>"鎿",
	镏=>"鎦", 镐=>"鎬", 镑=>"鎊", 镒=>"鎰", 镓=>"鎵", 镔=>"鑌",
	镖=>"鏢", 镗=>"鏜", 镘=>"鏝", 镙=>"鏍", 镛=>"鏞", 镜=>"鏡",
	镝=>"鏑", 镞=>"鏃", 镟=>"鏇", 镡=>"鐔", 镢=>"鐝", 镣=>"鐐",
	镤=>"鏷", 镥=>"鑥", 镦=>"鐓", 镧=>"鑭", 镨=>"鐠", 镩=>"鑹",
	镪=>"鏹", 镫=>"鐙", 镬=>"鑊", 镭=>"鐳", 镯=>"鐲", 镰=>"鐮",
	镱=>"鐿", 镲=>"鑔", 镳=>"鑣", 镶=>"鑲", 长=>"長", 门=>"門",
	闩=>"閂", 闪=>"閃", 闫=>"閆", 闭=>"閉", 问=>"問", 闯=>"闖",
	闰=>"閏", 闱=>"闈", 闲=>"閑", 闳=>"閎", 间=>"間", 闵=>"閔",
	闶=>"閌", 闷=>"悶", 闸=>"閘", 闹=>"鬧", 闺=>"閨", 闻=>"聞",
	闼=>"闥", 闽=>"閩", 闾=>"閭", 阀=>"閥", 阁=>"閣", 阂=>"閡",
	阃=>"閫", 阄=>"鬮", 阅=>"閲", 阆=>"閬", 阈=>"閾", 阉=>"閹",
	阊=>"閶", 阋=>"鬩", 阌=>"閿", 阍=>"閽", 阎=>"閻", 阏=>"閼",
	阐=>"闡", 阑=>"闌", 阒=>"闃", 阔=>"闊", 阕=>"闋", 阖=>"闔",
	阗=>"闐", 阙=>"闕", 阚=>"闞", 队=>"隊", 阳=>"陽", 阴=>"陰",
	阵=>"陣", 阶=>"階", 际=>"際", 陆=>"陸", 陇=>"隴", 陈=>"陳",
	陉=>"陘", 陕=>"陝", 陧=>"隉", 陨=>"隕", 险=>"險", 随=>"隨",
	隐=>"隱", 隶=>"隸", 难=>"難", 雏=>"雛", 雠=>"讎", 雳=>"靂",
	雾=>"霧", 霁=>"霽", 霭=>"靄", 靓=>"靚", 静=>"靜", 靥=>"靨",
	鞑=>"韃", 鞒=>"鞽", 鞯=>"韉", 韦=>"韋", 韧=>"韌", 韩=>"韓",
	韪=>"韙", 韫=>"韞", 韬=>"韜", 页=>"頁", 顶=>"頂", 顷=>"頃",
	顸=>"頇", 项=>"項", 顺=>"順", 顼=>"頊", 顽=>"頑", 顾=>"顧",
	顿=>"頓", 颀=>"頎", 颁=>"頒", 颂=>"頌", 颃=>"頏", 预=>"預",
	颅=>"顱", 领=>"領", 颇=>"頗", 颈=>"頸", 颉=>"頡", 颊=>"頰",
	颌=>"頜", 颍=>"潁", 颏=>"頦", 颐=>"頤", 频=>"頻", 颓=>"頽",
	颔=>"頷", 颖=>"穎", 颗=>"顆", 题=>"題", 颚=>"顎", 颛=>"顓",
	颜=>"顔", 额=>"額", 颞=>"顳", 颟=>"顢", 颠=>"顛", 颡=>"顙",
	颢=>"顥", 颤=>"顫", 颥=>"顬", 颦=>"顰", 颧=>"顴", 风=>"風",
	飑=>"颮", 飒=>"颯", 飓=>"颶", 飕=>"颼", 飘=>"飄", 飙=>"飆",
	飚=>"飈", 飞=>"飛", 飨=>"饗", 餍=>"饜", 饣=>"飠", 饥=>"饑",
	饧=>"餳", 饨=>"飩", 饩=>"餼", 饪=>"飪", 饫=>"飫", 饬=>"飭",
	饭=>"飯", 饮=>"飲", 饯=>"餞", 饰=>"飾", 饱=>"飽", 饲=>"飼",
	饴=>"飴", 饵=>"餌", 饶=>"饒", 饷=>"餉", 饺=>"餃", 饼=>"餅",
	饽=>"餑", 饿=>"餓", 馀=>"余", 馁=>"餒", 馄=>"餛", 馅=>"餡",
	馆=>"館", 馇=>"餷", 馈=>"饋", 馊=>"餿", 馋=>"饞", 馍=>"饃",
	馏=>"餾", 馐=>"饈", 馑=>"饉", 馒=>"饅", 馓=>"饊", 馔=>"饌",
	馕=>"饢", 马=>"馬", 驭=>"馭", 驮=>"馱", 驯=>"馴", 驰=>"馳",
	驱=>"驅", 驳=>"駁", 驴=>"驢", 驵=>"駔", 驶=>"駛", 驷=>"駟",
	驸=>"駙", 驹=>"駒", 驺=>"騶", 驻=>"駐", 驼=>"駝", 驽=>"駑",
	驾=>"駕", 驿=>"驛", 骀=>"駘", 骁=>"驍", 骂=>"駡", 骄=>"驕",
	骅=>"驊", 骆=>"駱", 骇=>"駭", 骈=>"駢", 骊=>"驪", 骋=>"騁",
	验=>"驗", 骏=>"駿", 骐=>"騏", 骑=>"騎", 骒=>"騍", 骓=>"騅",
	骖=>"驂", 骗=>"騙", 骘=>"騭", 骚=>"騷", 骛=>"騖", 骜=>"驁",
	骝=>"騮", 骞=>"騫", 骟=>"騸", 骠=>"驃", 骡=>"騾", 骢=>"驄",
	骣=>"驏", 骤=>"驟", 骥=>"驥", 骧=>"驤", 髅=>"髏", 髋=>"髖",
	髌=>"髕", 鬓=>"鬢", 魇=>"魘", 魉=>"魎", 鱼=>"魚", 鱿=>"魷",
	鲁=>"魯", 鲂=>"魴", 鲅=>"鮁", 鲆=>"鮃", 鲇=>"鮎", 鲈=>"鱸",
	鲋=>"鮒", 鲍=>"鮑", 鲎=>"鱟", 鲐=>"鮐", 鲑=>"鮭", 鲒=>"鮚",
	鲔=>"鮪", 鲕=>"鮞", 鲚=>"鱭", 鲛=>"鮫", 鲜=>"鮮", 鲞=>"鮝",
	鲟=>"鱘", 鲠=>"鯁", 鲡=>"鱺", 鲢=>"鰱", 鲣=>"鰹", 鲤=>"鯉",
	鲥=>"鰣", 鲦=>"鰷", 鲧=>"鯀", 鲨=>"鯊", 鲩=>"鯇", 鲫=>"鯽",
	鲭=>"鯖", 鲮=>"鯪", 鲰=>"鯫", 鲱=>"鯡", 鲲=>"鯤", 鲳=>"鯧",
	鲴=>"鯝", 鲵=>"鯢", 鲶=>"鯰", 鲷=>"鯛", 鲸=>"鯨", 鲺=>"鯴",
	鲻=>"鯔", 鲼=>"鱝", 鲽=>"鰈", 鳃=>"鰓", 鳄=>"鰐", 鳅=>"鰍",
	鳆=>"鰒", 鳇=>"鰉", 鳊=>"鯿", 鳋=>"鰠", 鳌=>"鰲", 鳍=>"鰭",
	鳎=>"鰨", 鳏=>"鰥", 鳐=>"鰩", 鳓=>"鰳", 鳔=>"鰾", 鳕=>"鱈",
	鳖=>"鱉", 鳗=>"鰻", 鳘=>"鰵", 鳙=>"鱅", 鳜=>"鱖", 鳝=>"鱔",
	鳞=>"鱗", 鳟=>"鱒", 鳢=>"鱧", 鸟=>"鳥", 鸠=>"鳩", 鸢=>"鳶",
	鸣=>"鳴", 鸥=>"鷗", 鸦=>"鴉", 鸨=>"鴇", 鸩=>"鴆", 鸪=>"鴣",
	鸫=>"鶇", 鸬=>"鸕", 鸭=>"鴨", 鸯=>"鴦", 鸱=>"鴟", 鸲=>"鴝",
	鸳=>"鴛", 鸵=>"鴕", 鸶=>"鷥", 鸷=>"鷙", 鸸=>"鴯", 鸹=>"鴰",
	鸺=>"鵂", 鸽=>"鴿", 鸾=>"鸞", 鸿=>"鴻", 鹁=>"鵓", 鹂=>"鸝",
	鹃=>"鵑", 鹄=>"鵠", 鹅=>"鵝", 鹆=>"鵒", 鹇=>"鷳", 鹈=>"鵜",
	鹉=>"鵡", 鹊=>"鵲", 鹋=>"鶓", 鹌=>"鵪", 鹎=>"鵯", 鹏=>"鵬",
	鹑=>"鶉", 鹕=>"鶘", 鹗=>"鶚", 鹘=>"鶻", 鹚=>"鷀", 鹛=>"鶥",
	鹜=>"鶩", 鹞=>"鷂", 鹣=>"鶼", 鹤=>"鶴", 鹦=>"鸚", 鹧=>"鷓",
	鹨=>"鷚", 鹩=>"鷯", 鹪=>"鷦", 鹫=>"鷲", 鹬=>"鷸", 鹭=>"鷺",
	鹰=>"鷹", 鹱=>"鸌", 鹳=>"鸛", 鹾=>"鹺", 麦=>"麥", 麸=>"麩",
	麽=>"么", 黉=>"黌", 黩=>"黷", 黪=>"黲", 黾=>"黽", 鼋=>"黿",
	鼍=>"鼉", 齐=>"齊", 齑=>"齏", 齿=>"齒", 龀=>"齔", 龃=>"齟",
	龄=>"齡", 龅=>"齙", 龆=>"齠", 龇=>"齜", 龈=>"齦", 龉=>"齬",
	龊=>"齪", 龋=>"齲", 龌=>"齷", 龙=>"龍", 龚=>"龔", 龛=>"龕",
	龟=>"龜",
);
our %simp = ( # string of possible simplified chars for each traditional char
	乾=>"乾干",  后=>"后後",  壹=>"壹壸",  夥=>"夥伙", 師=>"帅师",
	後=>"後后",  徵=>"徵征",  捨=>"舍舎", 摺=>"摺折",  棗=>"枣栆",
	瀋=>"沈渖",  獲=>"荻获", 當=>"当带",  總=>"总怼",  膽=>"胆幞",
	藉=>"藉借", 車=>"車车",  辦=>"刅办",  適=>"适逃",  遽=>"遽业",
	邃=>"邃还",  邊=>"边辺",  鍾=>"钟锺",  鏇=>"镟旋",  閣=>"合阁",
	隹=>"隹只", 顰=>"颦显",  飛=>"飛飞",  麽=>"麽么",  龜=>"龟",

	亂=>"乱", 亜=>"亚", 亞=>"亚", 佇=>"伫", 來=>"来", 侖=>"仑",
	係=>"系", 俠=>"侠", 倀=>"伥", 倆=>"俩", 倉=>"仓", 個=>"个",
	們=>"们", 倫=>"伦", 偉=>"伟", 側=>"侧", 偵=>"侦", 傖=>"伧",
	傘=>"伞", 備=>"备", 傢=>"家", 傭=>"佣", 傳=>"传", 傴=>"伛",
	債=>"债", 傷=>"伤", 傾=>"倾", 僂=>"偻", 僅=>"仅", 僉=>"佥",
	僑=>"侨", 僕=>"仆", 僞=>"伪", 僥=>"侥", 僨=>"偾", 價=>"价",
	儀=>"仪", 儂=>"侬", 億=>"亿", 儈=>"侩", 儉=>"俭", 儐=>"傧",
	儔=>"俦", 儕=>"侪", 儘=>"尽", 償=>"偿", 優=>"优", 儲=>"储",
	儷=>"俪", 儺=>"傩", 儻=>"傥", 儼=>"俨", 兒=>"儿", 兩=>"两",
	凈=>"净", 凍=>"冻", 凖=>"准", 凱=>"凯", 剄=>"刭", 則=>"则",
	剋=>"克", 剛=>"刚", 剮=>"剐", 剴=>"剀", 創=>"创", 劃=>"划",
	劇=>"剧", 劉=>"刘", 劊=>"刽", 劌=>"刿", 劍=>"剑", 劑=>"剂",
	勁=>"劲", 動=>"动", 務=>"务", 勛=>"勋", 勝=>"胜", 勞=>"劳",
	勢=>"势", 勱=>"劢", 勵=>"励", 勸=>"劝", 匭=>"匦", 匯=>"汇",
	匱=>"匮", 區=>"区", 協=>"协", 厙=>"厍", 厠=>"厕", 厭=>"厌",
	厲=>"厉", 厴=>"厣", 參=>"参", 叢=>"丛", 咼=>"呙", 員=>"员",
	唄=>"呗", 問=>"问", 啓=>"启", 啞=>"哑", 啟=>"启", 喚=>"唤",
	喪=>"丧", 喬=>"乔", 單=>"单", 喲=>"哟", 嗆=>"呛", 嗇=>"啬",
	嗎=>"吗", 嗚=>"呜", 嗩=>"唢", 嗶=>"哔", 嘆=>"叹", 嘍=>"喽",
	嘔=>"呕", 嘖=>"啧", 嘗=>"尝", 嘜=>"唛", 嘩=>"哗", 嘮=>"唠",
	嘯=>"啸", 嘰=>"叽", 嘵=>"哓", 嘸=>"呒", 噝=>"咝", 噠=>"哒",
	噥=>"哝", 噦=>"哕", 噯=>"嗳", 噲=>"哙", 噴=>"喷", 噸=>"吨",
	噹=>"带", 嚀=>"咛", 嚇=>"吓", 嚌=>"哜", 嚕=>"噜", 嚙=>"啮",
	嚦=>"呖", 嚨=>"咙", 嚮=>"向", 嚳=>"喾", 嚴=>"严", 嚶=>"嘤",
	囀=>"啭", 囁=>"嗫", 囂=>"嚣", 囅=>"冁", 囈=>"呓", 囌=>"苏",
	囑=>"嘱", 圇=>"囵", 國=>"国", 圍=>"围", 園=>"园", 圓=>"圆",
	圖=>"图", 團=>"团", 埡=>"垭", 執=>"执", 堅=>"坚", 堊=>"垩",
	堖=>"垴", 堝=>"埚", 堯=>"尧", 報=>"报", 場=>"场", 塊=>"块",
	塋=>"茔", 塏=>"垲", 塒=>"埘", 塗=>"涂", 塢=>"坞", 塤=>"埙",
	塵=>"尘", 塹=>"堑", 墊=>"垫", 墜=>"坠", 墮=>"堕", 墳=>"坟",
	墻=>"墙", 墾=>"垦", 壇=>"坛", 壓=>"压", 壘=>"垒", 壙=>"圹",
	壚=>"垆", 壞=>"坏", 壟=>"垄", 壠=>"垅", 壢=>"坜", 壩=>"坝",
	壯=>"壮", 壺=>"壶", 壽=>"寿", 夢=>"梦", 夾=>"夹", 奐=>"奂",
	奩=>"奁", 奪=>"夺", 奬=>"奖", 奮=>"奋", 妝=>"妆", 婁=>"娄",
	婦=>"妇", 婭=>"娅", 媧=>"娲", 媽=>"妈", 嫗=>"妪", 嫵=>"妩",
	嫻=>"娴", 嬀=>"妫", 嬈=>"娆", 嬋=>"婵", 嬌=>"娇", 嬙=>"嫱",
	嬡=>"嫒", 嬪=>"嫔", 嬰=>"婴", 嬸=>"婶", 孌=>"娈", 孫=>"孙",
	學=>"学", 孿=>"孪", 寢=>"寝", 實=>"实", 寧=>"宁", 審=>"审",
	寫=>"写", 寬=>"宽", 寵=>"宠", 寶=>"宝", 將=>"将", 專=>"专",
	尋=>"寻", 對=>"对", 導=>"导", 尷=>"尴", 屢=>"屡", 層=>"层",
	屨=>"屦", 屬=>"属", 岡=>"冈", 峴=>"岘", 島=>"岛", 峽=>"峡",
	崍=>"崃", 崗=>"岗", 崢=>"峥", 崬=>"岽", 嵐=>"岚", 嶁=>"嵝",
	嶄=>"崭", 嶇=>"岖", 嶗=>"崂", 嶠=>"峤", 嶧=>"峄", 嶸=>"嵘",
	嶺=>"岭", 嶼=>"屿", 巋=>"岿", 巒=>"峦", 巔=>"巅", 巰=>"巯",
	帥=>"帅", 帳=>"帐", 帶=>"带", 幀=>"帧", 幃=>"帏", 幗=>"帼",
	幘=>"帻", 幚=>"帮", 幟=>"帜", 幣=>"币", 幫=>"帮", 幬=>"帱",
	幹=>"干", 幾=>"几", 庫=>"库", 廈=>"庆", 廟=>"庙", 廠=>"厂",
	廡=>"庑", 廢=>"废", 廣=>"广", 廬=>"庐", 廳=>"厅", 弳=>"弪",
	張=>"张", 彆=>"別", 彈=>"弹", 彌=>"弥", 彎=>"弯", 彙=>"汇",
	徑=>"径", 從=>"从", 徠=>"徕", 復=>"复", 徹=>"彻", 悵=>"怅",
	悶=>"闷", 惡=>"恶", 惱=>"恼", 惲=>"恽", 惻=>"恻", 愛=>"爱",
	愜=>"惬", 愴=>"怆", 愷=>"恺", 愾=>"忾", 態=>"态", 慘=>"惨",
	慚=>"惭", 慟=>"恸", 慣=>"惯", 慤=>"悫", 慪=>"怄", 慫=>"怂",
	慮=>"虑", 慳=>"悭", 慶=>"庆", 憂=>"忧", 憊=>"惫", 憐=>"怜",
	憑=>"凭", 憒=>"愦", 憚=>"惮", 憤=>"愤", 憫=>"悯", 憮=>"怃",
	憲=>"宪", 憶=>"忆", 懇=>"恳", 應=>"应", 懌=>"怿", 懞=>"蒙",
	懟=>"怼", 懣=>"懑", 懨=>"恹", 懲=>"惩", 懶=>"懒", 懷=>"怀",
	懸=>"悬", 懺=>"忏", 懼=>"惧", 懾=>"慑", 戀=>"恋", 戇=>"戆",
	戔=>"戋", 戧=>"戗", 戩=>"戬", 戰=>"战", 戲=>"戏", 挾=>"挟",
	捫=>"扪", 捲=>"卷", 掃=>"扫", 掄=>"抡", 掙=>"挣", 揀=>"拣",
	揚=>"扬", 換=>"换", 揮=>"挥", 損=>"损", 搗=>"捣", 搶=>"抢",
	摑=>"掴", 摜=>"掼", 摟=>"搂", 摯=>"挚", 摳=>"抠", 摶=>"抟",
	摻=>"掺", 撈=>"捞", 撓=>"挠", 撟=>"挢", 撣=>"掸", 撥=>"拨",
	撫=>"抚", 撲=>"扑", 撳=>"揿", 撻=>"挞", 撾=>"挝", 撿=>"捡",
	擁=>"拥", 擄=>"掳", 擇=>"择", 擊=>"击", 擋=>"挡", 擔=>"担",
	據=>"据", 擠=>"挤", 擬=>"拟", 擯=>"摈", 擰=>"拧", 擱=>"搁",
	擲=>"掷", 擴=>"扩", 擷=>"撷", 擺=>"摆", 擻=>"擞", 擼=>"撸",
	擾=>"扰", 攄=>"摅", 攆=>"撵", 攏=>"拢", 攔=>"拦", 攖=>"撄",
	攙=>"搀", 攛=>"撺", 攝=>"摄", 攢=>"攒", 攣=>"挛", 攤=>"摊",
	攪=>"搅", 攬=>"揽", 敗=>"败", 敵=>"敌", 數=>"数", 斂=>"敛",
	斃=>"毙", 斕=>"斓", 斬=>"斩", 斷=>"断", 時=>"时", 晉=>"晋",
	晝=>"昼", 暈=>"晕", 暉=>"晖", 暢=>"畅", 暫=>"暂", 曄=>"晔",
	曆=>"历", 曇=>"昙", 曉=>"晓", 曖=>"暧", 曠=>"旷", 曬=>"晒",
	書=>"书", 會=>"会", 朧=>"胧", 東=>"东", 梘=>"枧", 條=>"条",
	梟=>"枭", 棄=>"弃", 棖=>"枨", 棟=>"栋", 棧=>"栈", 棲=>"栖",
	椏=>"桠", 楊=>"杨", 楓=>"枫", 楨=>"桢", 業=>"业", 極=>"极",
	榪=>"杩", 榮=>"荣", 榿=>"桤", 構=>"构", 槍=>"枪", 様=>"样",
	槧=>"椠", 槳=>"桨", 樁=>"桩", 樂=>"乐", 樅=>"枞", 樓=>"楼",
	標=>"标", 樞=>"枢", 樣=>"样", 樸=>"朴", 樹=>"树", 樺=>"桦",
	橈=>"桡", 橋=>"桥", 機=>"机", 橢=>"椭", 檉=>"柽", 檔=>"档",
	檜=>"桧", 檢=>"检", 檣=>"樯", 檯=>"台", 檳=>"槟", 檸=>"柠",
	檻=>"槛", 櫃=>"柜", 櫓=>"橹", 櫚=>"榈", 櫛=>"栉", 櫝=>"椟",
	櫞=>"橼", 櫟=>"栎", 櫧=>"槠", 櫨=>"栌", 櫪=>"枥", 櫬=>"榇",
	櫳=>"栊", 櫸=>"榉", 櫻=>"樱", 欄=>"栏", 權=>"权", 欏=>"椤",
	欒=>"栾", 欖=>"榄", 欗=>"栏", 欞=>"棂", 欽=>"钦", 歐=>"欧",
	歟=>"欤", 歡=>"欢", 歲=>"岁", 歳=>"岁", 歷=>"历", 歸=>"归",
	殘=>"残", 殞=>"殒", 殤=>"殇", 殫=>"殚", 殮=>"殓", 殯=>"殡",
	殲=>"歼", 殺=>"杀", 殻=>"壳", 殼=>"壳", 毆=>"殴", 毿=>"毵",
	氈=>"毡", 氌=>"氇", 氣=>"气", 氫=>"氢", 氬=>"氩", 浹=>"浃",
	涇=>"泾", 淪=>"沦", 淵=>"渊", 淶=>"涞", 淺=>"浅", 渙=>"涣",
	渦=>"涡", 測=>"测", 渾=>"浑", 湞=>"浈", 湯=>"汤", 準=>"准",
	溝=>"沟", 滄=>"沧", 滅=>"灭", 滌=>"涤", 滎=>"荥", 滬=>"沪",
	滯=>"滞", 滲=>"渗", 滷=>"卤", 滸=>"浒", 滿=>"满", 漁=>"渔",
	漚=>"沤", 漢=>"汉", 漣=>"涟", 漬=>"渍", 漲=>"涨", 漸=>"渐",
	漿=>"浆", 潁=>"颍", 潑=>"泼", 潔=>"洁", 潙=>"沩", 潛=>"潜",
	潤=>"润", 潯=>"浔", 潰=>"溃", 潷=>"滗", 潿=>"涠", 澀=>"涩",
	澆=>"浇", 澇=>"涝", 澗=>"涧", 澠=>"渑", 澤=>"泽", 澩=>"泶",
	澮=>"浍", 澱=>"淀", 濁=>"浊", 濃=>"浓", 濕=>"湿", 濘=>"泞",
	濛=>"蒙", 濟=>"济", 濤=>"涛", 濫=>"滥", 濰=>"潍", 濱=>"滨",
	濺=>"溅", 濼=>"泺", 濾=>"滤", 瀅=>"滢", 瀆=>"渎", 瀉=>"泻",
	瀏=>"浏", 瀕=>"濒", 瀘=>"泸", 瀝=>"沥", 瀟=>"潇", 瀠=>"潆",
	瀧=>"泷", 瀨=>"濑", 瀲=>"潋", 瀾=>"澜", 灃=>"沣", 灄=>"滠",
	灑=>"洒", 灕=>"漓", 灘=>"滩", 灝=>"灏", 灣=>"湾", 灤=>"滦",
	灧=>"滟", 為=>"为", 烏=>"乌", 烴=>"烃", 無=>"无", 煉=>"炼",
	煒=>"炜", 煢=>"茕", 煥=>"焕", 煩=>"烦", 煬=>"炀", 熒=>"荧",
	熗=>"炝", 熱=>"热", 熾=>"炽", 燁=>"烨", 燈=>"灯", 燒=>"烧",
	燙=>"烫", 燜=>"焖", 營=>"营", 燦=>"灿", 燭=>"烛", 燴=>"烩",
	燼=>"烬", 燾=>"焘", 爍=>"烁", 爐=>"炉", 爛=>"烂", 爤=>"烂",
	爭=>"争", 爲=>"为", 爺=>"爷", 爾=>"尔", 牘=>"牍", 牽=>"牵",
	犖=>"荦", 犢=>"犊", 犧=>"牺", 狀=>"状", 狹=>"狭", 狽=>"狈",
	猙=>"狰", 猶=>"犹", 猻=>"狲", 獁=>"犸", 獄=>"狱", 獅=>"狮",
	獨=>"独", 獪=>"狯", 獫=>"猃", 獰=>"狞", 獵=>"猎", 獷=>"犷",
	獸=>"兽", 獺=>"獭", 獻=>"献", 獼=>"猕", 玀=>"猡", 現=>"现",
	琿=>"珲", 瑋=>"玮", 瑣=>"琐", 瑩=>"莹", 瑪=>"玛", 璉=>"琏",
	璣=>"玑", 璦=>"瑷", 環=>"环", 璽=>"玺", 瓊=>"琼", 瓏=>"珑",
	瓔=>"璎", 瓚=>"瓒", 甌=>"瓯", 產=>"产", 産=>"产", 畆=>"亩",
	畝=>"亩", 畢=>"毕", 畫=>"画", 疇=>"畴", 疊=>"叠", 痙=>"痉",
	瘂=>"痖", 瘋=>"疯", 瘍=>"疡", 瘓=>"痪", 瘞=>"瘗", 瘡=>"疮",
	瘧=>"疟", 瘻=>"瘘", 療=>"疗", 癆=>"痨", 癇=>"痫", 癉=>"瘅",
	癘=>"疠", 癟=>"瘪", 癢=>"痒", 癤=>"疖", 癥=>"症", 癧=>"疬",
	癩=>"癞", 癬=>"癣", 癭=>"瘿", 癮=>"瘾", 癰=>"痈", 癱=>"瘫",
	癲=>"癫", 發=>"发", 皚=>"皑", 皸=>"皲", 皺=>"皱", 盞=>"盏",
	盡=>"尽", 監=>"监", 盤=>"盘", 盧=>"卢", 眾=>"众", 睏=>"困",
	睜=>"睁", 睞=>"睐", 瞘=>"眍", 瞞=>"瞒", 瞭=>"了", 瞼=>"睑",
	矇=>"蒙", 矚=>"瞩", 矯=>"矫", 硃=>"朱", 硤=>"硖", 硨=>"砗",
	硯=>"砚", 碩=>"硕", 碭=>"砀", 碸=>"砜", 確=>"确", 碼=>"码",
	磚=>"砖", 磣=>"碜", 磧=>"碛", 磯=>"矶", 磽=>"硗", 礎=>"础",
	礙=>"碍", 礦=>"矿", 礪=>"砺", 礫=>"砾", 礬=>"矾", 礱=>"砻",
	祇=>"只", 禍=>"祸", 禎=>"祯", 禦=>"御", 禪=>"禅", 禮=>"礼",
	禰=>"祢", 禱=>"祷", 種=>"种", 稱=>"称", 穀=>"谷", 穌=>"稣",
	積=>"积", 穎=>"颖", 穡=>"穑", 穢=>"秽", 穩=>"稳", 穫=>"荻",
	窩=>"窝", 窪=>"洼", 窮=>"穷", 窶=>"窭", 窺=>"窥", 竄=>"窜",
	竅=>"窍", 竇=>"窦", 竈=>"灶", 竊=>"窃", 竪=>"竖", 競=>"竞",
	筆=>"笔", 筧=>"笕", 箋=>"笺", 箏=>"筝", 節=>"节", 範=>"范",
	築=>"筑", 篋=>"箧", 篤=>"笃", 篩=>"筛", 篳=>"筚", 簀=>"箦",
	簍=>"篓", 簞=>"箪", 簡=>"简", 簣=>"篑", 簫=>"箫", 簽=>"签",
	簾=>"帘", 籃=>"篮", 籌=>"筹", 籜=>"箨", 籟=>"籁", 籠=>"笼",
	籤=>"签", 籩=>"笾", 籪=>"簖", 籬=>"篱", 籮=>"箩", 糝=>"糁",
	糞=>"粪", 糧=>"粮", 糰=>"团", 糲=>"粝", 糴=>"籴", 糶=>"粜",
	糹=>"纟", 糾=>"纠", 紀=>"纪", 紂=>"纣", 約=>"约", 紅=>"红",
	紆=>"纡", 紇=>"纥", 紈=>"纨", 紉=>"纫", 紋=>"纹", 納=>"纳",
	紐=>"纽", 紓=>"纾", 純=>"纯", 紕=>"纰", 紗=>"纱", 紙=>"纸",
	級=>"级", 紛=>"纷", 紜=>"纭", 紡=>"纺", 細=>"细", 紱=>"绂",
	紲=>"绁", 紳=>"绅", 紹=>"绍", 紺=>"绀", 紼=>"绋", 紿=>"绐",
	絀=>"绌", 終=>"终", 組=>"组", 絆=>"绊", 絎=>"绗", 結=>"结",
	絝=>"绔", 絞=>"绞", 絡=>"络", 絢=>"绚", 給=>"给", 絨=>"绒",
	統=>"统", 絲=>"丝", 絳=>"绛", 絶=>"绝", 絹=>"绢", 綁=>"绑",
	綃=>"绡", 綆=>"绠", 綈=>"绨", 綉=>"绣", 綏=>"绥", 經=>"经",
	綜=>"综", 綞=>"缍", 綢=>"绸", 綣=>"绻", 綫=>"线", 綬=>"绶",
	維=>"维", 綰=>"绾", 綱=>"纲", 網=>"网", 綳=>"绷", 綴=>"缀",
	綸=>"纶", 綹=>"绺", 綺=>"绮", 綻=>"绽", 綽=>"绰", 綾=>"绫",
	綿=>"绵", 緄=>"绲", 緇=>"缁", 緊=>"紧", 緋=>"绯", 緑=>"绿",
	緒=>"绪", 緔=>"绱", 緗=>"缃", 緘=>"缄", 緙=>"缂", 緝=>"缉",
	緞=>"缎", 締=>"缔", 緡=>"缗", 緣=>"缘", 緦=>"缌", 編=>"编",
	緩=>"缓", 緬=>"缅", 緯=>"纬", 緱=>"缑", 緲=>"缈", 練=>"练",
	緶=>"缏", 緹=>"缇", 緻=>"致", 縈=>"萦", 縉=>"缙", 縊=>"缢",
	縋=>"缒", 縐=>"绉", 縑=>"缣", 縛=>"缚", 縝=>"缜", 縞=>"缟",
	縟=>"缛", 縣=>"县", 縧=>"绦", 縫=>"缝", 縭=>"缡", 縮=>"缩",
	縱=>"纵", 縲=>"缧", 縴=>"纤", 縵=>"缦", 縶=>"絷", 縷=>"缕",
	縹=>"缥", 績=>"绩", 繅=>"缫", 繆=>"缪", 繒=>"缯", 織=>"织",
	繕=>"缮", 繚=>"缭", 繞=>"绕", 繢=>"缋", 繩=>"绳", 繪=>"绘",
	繫=>"系", 繭=>"茧", 繮=>"缰", 繯=>"缳", 繰=>"缲", 繳=>"缴",
	繹=>"绎", 繼=>"继", 繽=>"缤", 繾=>"缱", 纈=>"缬", 纊=>"纩",
	續=>"续", 纍=>"累", 纏=>"缠", 纓=>"缨", 纔=>"才", 纖=>"纤",
	纘=>"缵", 纜=>"缆", 罌=>"罂", 罎=>"坛", 罰=>"罚", 罷=>"罢",
	羅=>"罗", 羆=>"罴", 羈=>"羁", 羥=>"羟", 義=>"义", 習=>"习",
	翹=>"翘", 耬=>"耧", 耮=>"耢", 聖=>"圣", 聞=>"闻", 聯=>"联",
	聰=>"聪", 聲=>"声", 聳=>"耸", 聵=>"聩", 聶=>"聂", 職=>"职",
	聹=>"聍", 聽=>"听", 聾=>"聋", 肅=>"肃", 脅=>"胁", 脛=>"胫",
	脹=>"胀", 腎=>"肾", 腖=>"胨", 腡=>"脶", 腦=>"脑", 腫=>"肿",
	腸=>"肠", 膚=>"肤", 膠=>"胶", 膩=>"腻", 膾=>"脍", 膿=>"脓",
	臉=>"脸", 臍=>"脐", 臏=>"膑", 臘=>"腊", 臚=>"胪", 臟=>"脏",
	臠=>"脔", 臨=>"临", 臺=>"台", 與=>"与", 興=>"兴", 舉=>"举",
	舊=>"旧", 艙=>"舱", 艤=>"舣", 艦=>"舰", 艫=>"舻", 艱=>"艰",
	艷=>"艳", 芻=>"刍", 苧=>"苎", 莊=>"庄", 莖=>"茎", 莢=>"荚",
	莧=>"苋", 華=>"华", 萇=>"苌", 萊=>"莱", 萬=>"万", 萵=>"莴",
	葉=>"叶", 葒=>"荭", 葤=>"荮", 葦=>"苇", 葷=>"荤", 蒓=>"莼",
	蒔=>"莳", 蒼=>"苍", 蓀=>"荪", 蓋=>"盖", 蓮=>"莲", 蓯=>"苁",
	蓽=>"荜", 蔔=>"卜", 蔞=>"蒌", 蔣=>"蒋", 蔦=>"茑", 蔭=>"荫",
	蕁=>"荨", 蕆=>"蒇", 蕎=>"荞", 蕒=>"荬", 蕓=>"芸", 蕕=>"莸",
	蕘=>"荛", 蕢=>"蒉", 蕩=>"荡", 蕪=>"芜", 蕭=>"萧", 蕷=>"蓣",
	薈=>"荟", 薊=>"蓟", 薌=>"芗", 薑=>"姜", 薔=>"蔷", 薟=>"莶",
	薦=>"荐", 薩=>"萨", 薺=>"荠", 藍=>"蓝", 藎=>"荩", 藝=>"艺",
	藥=>"药", 藪=>"薮", 藴=>"蕴", 藶=>"苈", 藹=>"蔼", 藺=>"蔺",
	蘄=>"蕲", 蘆=>"芦", 蘇=>"苏", 蘋=>"苹", 蘚=>"藓", 蘞=>"蔹",
	蘢=>"茏", 蘭=>"兰", 蘺=>"蓠", 蘿=>"萝", 處=>"处", 虜=>"虏",
	號=>"号", 虧=>"亏", 蛺=>"蛱", 蜆=>"蚬", 蝕=>"蚀", 蝦=>"虾",
	蝸=>"蜗", 螄=>"蛳", 螞=>"蚂", 螢=>"萤", 螻=>"蝼", 蟄=>"蛰",
	蟈=>"蝈", 蟎=>"螨", 蟣=>"虮", 蟬=>"蝉", 蟯=>"蛲", 蟲=>"虫",
	蟶=>"蛏", 蟻=>"蚁", 蠅=>"蝇", 蠆=>"虿", 蠐=>"蛴", 蠑=>"蝾",
	蠟=>"蜡", 蠣=>"蛎", 蠱=>"蛊", 蠶=>"蚕", 蠺=>"蚕", 蠻=>"蛮",
	衆=>"众", 衊=>"蔑", 術=>"术", 衛=>"卫", 衝=>"冲", 衹=>"只",
	裊=>"袅", 裏=>"里", 補=>"补", 裝=>"装", 製=>"制", 複=>"复",
	褲=>"裤", 褳=>"裢", 褸=>"褛", 褻=>"亵", 襇=>"裥", 襖=>"袄",
	襝=>"裣", 襠=>"裆", 襤=>"褴", 襪=>"袜", 襯=>"衬", 襲=>"袭",
	見=>"见", 規=>"规", 覓=>"觅", 視=>"视", 覘=>"觇", 覡=>"觋",
	覦=>"觎", 親=>"亲", 覬=>"觊", 覯=>"觏", 覲=>"觐", 覷=>"觑",
	覺=>"觉", 覽=>"览", 覿=>"觌", 觀=>"观", 觴=>"觞", 觶=>"觯",
	觸=>"触", 訁=>"讠", 訂=>"订", 訃=>"讣", 計=>"计", 訊=>"讯",
	訌=>"讧", 討=>"讨", 訐=>"讦", 訓=>"训", 訕=>"讪", 訖=>"讫",
	記=>"记", 訛=>"讹", 訝=>"讶", 訟=>"讼", 訣=>"诀", 訥=>"讷",
	訪=>"访", 設=>"设", 許=>"许", 訴=>"诉", 訶=>"诃", 診=>"诊",
	詁=>"诂", 詆=>"诋", 詎=>"讵", 詐=>"诈", 詒=>"诒", 詔=>"诏",
	評=>"评", 詘=>"诎", 詛=>"诅", 詞=>"词", 詡=>"诩", 詢=>"询",
	詣=>"诣", 試=>"试", 詩=>"诗", 詫=>"诧", 詬=>"诟", 詭=>"诡",
	詮=>"诠", 詰=>"诘", 話=>"话", 該=>"该", 詳=>"详", 詵=>"诜",
	詼=>"诙", 詿=>"诖", 誄=>"诔", 誅=>"诛", 誆=>"诓", 誇=>"夸",
	認=>"认", 誑=>"诳", 誒=>"诶", 誕=>"诞", 誘=>"诱", 誚=>"诮",
	語=>"语", 誠=>"诚", 誡=>"诫", 誣=>"诬", 誤=>"误", 誥=>"诰",
	誦=>"诵", 誨=>"诲", 説=>"说", 誰=>"谁", 課=>"课", 誶=>"谇",
	誹=>"诽", 誼=>"谊", 調=>"调", 諂=>"谄", 諄=>"谆", 談=>"谈",
	諉=>"诿", 請=>"请", 諍=>"诤", 諏=>"诹", 諑=>"诼", 諒=>"谅",
	論=>"论", 諗=>"谂", 諛=>"谀", 諜=>"谍", 諞=>"谝", 諢=>"诨",
	諤=>"谔", 諦=>"谛", 諧=>"谐", 諫=>"谏", 諭=>"谕", 諮=>"谘",
	諱=>"讳", 諳=>"谙", 諶=>"谌", 諷=>"讽", 諸=>"诸", 諺=>"谚",
	諼=>"谖", 諾=>"诺", 謀=>"谋", 謁=>"谒", 謂=>"谓", 謄=>"誊",
	謅=>"诌", 謊=>"谎", 謎=>"谜", 謐=>"谧", 謔=>"谑", 謖=>"谡",
	謗=>"谤", 謙=>"谦", 謚=>"谥", 講=>"讲", 謝=>"谢", 謡=>"谣",
	謨=>"谟", 謫=>"谪", 謬=>"谬", 謭=>"谫", 謳=>"讴", 謹=>"谨",
	謾=>"谩", 證=>"证", 譎=>"谲", 譏=>"讥", 譖=>"谮", 識=>"识",
	譙=>"谯", 譚=>"谭", 譜=>"谱", 譫=>"谵", 譯=>"译", 議=>"议",
	譴=>"谴", 護=>"护", 譽=>"誉", 讀=>"读", 變=>"变", 讎=>"雠",
	讒=>"谗", 讓=>"让", 讕=>"谰", 讖=>"谶", 讜=>"谠", 讞=>"谳",
	豈=>"岂", 豐=>"丰", 貝=>"贝", 貞=>"贞", 負=>"负", 財=>"财",
	貢=>"贡", 貧=>"贫", 貨=>"货", 販=>"贩", 貪=>"贪", 貫=>"贯",
	責=>"责", 貯=>"贮", 貰=>"贳", 貲=>"赀", 貳=>"贰", 貴=>"贵",
	貶=>"贬", 買=>"买", 貸=>"贷", 貺=>"贶", 費=>"费", 貼=>"贴",
	貽=>"贻", 貿=>"贸", 賀=>"贺", 賁=>"贲", 賂=>"赂", 賃=>"赁",
	賄=>"贿", 賅=>"赅", 資=>"资", 賈=>"贾", 賊=>"贼", 賑=>"赈",
	賒=>"赊", 賓=>"宾", 賕=>"赇", 賚=>"赉", 賜=>"赐", 賞=>"赏",
	賠=>"赔", 賡=>"赓", 賢=>"贤", 賣=>"卖", 賤=>"贱", 賦=>"赋",
	賧=>"赕", 質=>"质", 賫=>"赍", 賬=>"账", 賭=>"赌", 賴=>"赖",
	賺=>"赚", 賻=>"赙", 購=>"购", 賽=>"赛", 賾=>"赜", 贄=>"贽",
	贅=>"赘", 贈=>"赠", 贊=>"赞", 贋=>"赝", 贍=>"赡", 贏=>"赢",
	贐=>"赆", 贓=>"赃", 贖=>"赎", 贛=>"赣", 贜=>"赃", 趕=>"赶",
	趙=>"赵", 趨=>"趋", 趲=>"趱", 踐=>"践", 踴=>"踊", 蹌=>"跄",
	蹕=>"跸", 蹣=>"蹒", 蹺=>"跷", 躉=>"趸", 躊=>"踌", 躋=>"跻",
	躍=>"跃", 躑=>"踯", 躒=>"跞", 躓=>"踬", 躚=>"跹", 躡=>"蹑",
	躥=>"蹿", 躦=>"躜", 躪=>"躏", 軀=>"躯", 軋=>"轧", 軌=>"轨",
	軍=>"军", 軒=>"轩", 軔=>"轫", 軛=>"轭", 軟=>"软", 軤=>"轷",
	軫=>"轸", 軲=>"轱", 軸=>"轴", 軹=>"轵", 軺=>"轺", 軻=>"轲",
	軼=>"轶", 軾=>"轼", 較=>"较", 輅=>"辂", 輇=>"辁", 載=>"载",
	輊=>"轾", 輒=>"辄", 輔=>"辅", 輕=>"轻", 輛=>"辆", 輜=>"辎",
	輝=>"辉", 輞=>"辋", 輟=>"辍", 輥=>"辊", 輦=>"辇", 輩=>"辈",
	輪=>"轮", 輯=>"辑", 輳=>"辏", 輸=>"输", 輻=>"辐", 輾=>"辗",
	輿=>"舆", 轂=>"毂", 轄=>"辖", 轅=>"辕", 轆=>"辘", 轉=>"转",
	轍=>"辙", 轎=>"轿", 轔=>"辚", 轟=>"轰", 轡=>"辔", 轢=>"轹",
	轤=>"轳", 辭=>"辞", 辮=>"辫", 辯=>"辩", 農=>"农", 迴=>"坳",
	逕=>"迳", 這=>"这", 連=>"连", 進=>"进", 運=>"运", 過=>"过",
	達=>"达", 違=>"违", 遜=>"逊", 遞=>"递", 遠=>"远", 遲=>"迟",
	遷=>"迁", 選=>"选", 遺=>"遗", 遼=>"辽", 邁=>"迈", 還=>"还",
	邇=>"迩", 邏=>"逻", 邐=>"逦", 郟=>"郏", 郵=>"邮", 郷=>"乡",
	鄆=>"郓", 鄉=>"乡", 鄒=>"邹", 鄔=>"邬", 鄖=>"郧", 鄧=>"邓",
	鄭=>"郑", 鄰=>"邻", 鄲=>"郸", 鄴=>"邺", 鄶=>"郐", 鄺=>"邝",
	酈=>"郦", 醖=>"酝", 醜=>"丑", 醞=>"酝", 醫=>"医", 醬=>"酱",
	釀=>"酿", 釁=>"衅", 釃=>"酾", 釅=>"酽", 釋=>"释", 釒=>"钅",
	釓=>"钆", 釔=>"钇", 釕=>"钌", 釗=>"钊", 釘=>"钉", 釙=>"钋",
	針=>"针", 釣=>"钓", 釤=>"钐", 釧=>"钏", 釩=>"钒", 釵=>"钗",
	釷=>"钍", 釹=>"钕", 釺=>"钎", 鈀=>"钯", 鈁=>"钫", 鈄=>"钭",
	鈈=>"钚", 鈉=>"钠", 鈍=>"钝", 鈎=>"钩", 鈐=>"钤", 鈑=>"钣",
	鈔=>"钞", 鈕=>"钮", 鈞=>"钧", 鈣=>"钙", 鈥=>"钬", 鈦=>"钛",
	鈧=>"钪", 鈮=>"铌", 鈰=>"铈", 鈳=>"钶", 鈴=>"铃", 鈷=>"钴",
	鈸=>"钹", 鈹=>"铍", 鈺=>"钰", 鈽=>"钸", 鈾=>"铀", 鈿=>"钿",
	鉀=>"钾", 鉅=>"钜", 鉈=>"铊", 鉉=>"铉", 鉍=>"铋", 鉑=>"铂",
	鉕=>"钷", 鉗=>"钳", 鉚=>"铆", 鉛=>"铅", 鉞=>"钺", 鉢=>"钵",
	鉦=>"钲", 鉬=>"钼", 鉭=>"钽", 鉸=>"铰", 鉺=>"铒", 鉻=>"铬",
	鉿=>"铪", 銀=>"银", 銃=>"铳", 銅=>"铜", 銑=>"铣", 銓=>"铨",
	銖=>"铢", 銘=>"铭", 銚=>"铫", 銜=>"衔", 銠=>"铑", 銣=>"铷",
	銥=>"铱", 銦=>"铟", 銨=>"铵", 銩=>"铥", 銪=>"铕", 銫=>"铯",
	銬=>"铐", 銱=>"铞", 銷=>"销", 銹=>"锈", 銻=>"锑", 銼=>"锉",
	鋁=>"铝", 鋃=>"锒", 鋅=>"锌", 鋇=>"钡", 鋌=>"铤", 鋏=>"铗",
	鋒=>"锋", 鋝=>"锊", 鋟=>"锓", 鋣=>"铘", 鋤=>"锄", 鋥=>"锃",
	鋦=>"锔", 鋨=>"锇", 鋪=>"铺", 鋭=>"锐", 鋮=>"铖", 鋯=>"锆",
	鋰=>"锂", 鋱=>"铽", 鋶=>"锍", 鋸=>"锯", 鋼=>"钢", 錁=>"锞",
	錆=>"锖", 錇=>"锫", 錈=>"锩", 錐=>"锥", 錒=>"锕", 錕=>"锟",
	錘=>"锤", 錙=>"锱", 錚=>"铮", 錛=>"锛", 錟=>"锬", 錠=>"锭",
	錢=>"钱", 錦=>"锦", 錨=>"锚", 錫=>"锡", 錮=>"锢", 錯=>"错",
	録=>"录", 錳=>"锰", 錶=>"表", 錸=>"铼", 鍀=>"锝", 鍁=>"锨",
	鍃=>"锪", 鍆=>"钔", 鍇=>"锴", 鍋=>"锅", 鍍=>"镀", 鍔=>"锷",
	鍘=>"铡", 鍛=>"锻", 鍤=>"锸", 鍥=>"锲", 鍩=>"锘", 鍬=>"锹",
	鍰=>"锾", 鍵=>"键", 鍶=>"锶", 鍺=>"锗", 鎂=>"镁", 鎄=>"锿",
	鎇=>"镅", 鎊=>"镑", 鎖=>"锁", 鎘=>"镉", 鎢=>"钨", 鎣=>"蓥",
	鎦=>"镏", 鎧=>"铠", 鎩=>"铩", 鎪=>"锼", 鎬=>"镐", 鎮=>"镇",
	鎰=>"镒", 鎳=>"镍", 鎵=>"镓", 鎸=>"镌", 鎿=>"镎", 鏃=>"镞",
	鏈=>"链", 鏌=>"镆", 鏍=>"镙", 鏑=>"镝", 鏗=>"铿", 鏘=>"锵",
	鏜=>"镗", 鏝=>"镘", 鏞=>"镛", 鏟=>"铲", 鏡=>"镜", 鏢=>"镖",
	鏤=>"镂", 鏨=>"錾", 鏵=>"铧", 鏷=>"镤", 鏹=>"镪", 鐃=>"铙",
	鐋=>"铴", 鐐=>"镣", 鐒=>"铹", 鐓=>"镦", 鐔=>"镡", 鐘=>"钟",
	鐙=>"镫", 鐝=>"镢", 鐠=>"镨", 鐦=>"锎", 鐧=>"锏", 鐨=>"镄",
	鐮=>"镰", 鐲=>"镯", 鐳=>"镭", 鐵=>"铁", 鐸=>"铎", 鐺=>"铛",
	鐿=>"镱", 鑄=>"铸", 鑊=>"镬", 鑌=>"镔", 鑒=>"鉴", 鑔=>"镲",
	鑠=>"铄", 鑣=>"镳", 鑥=>"镥", 鑭=>"镧", 鑰=>"钥", 鑲=>"镶",
	鑷=>"镊", 鑹=>"镩", 鑼=>"锣", 鑽=>"钻", 鑾=>"銮", 鑿=>"凿",
	長=>"长", 門=>"门", 閂=>"闩", 閃=>"闪", 閆=>"闫", 閉=>"闭",
	開=>"开", 閌=>"闶", 閎=>"闳", 閏=>"闰", 閑=>"闲", 間=>"间",
	閔=>"闵", 閘=>"闸", 閡=>"阂", 閥=>"阀", 閨=>"闺", 閩=>"闽",
	閫=>"阃", 閬=>"阆", 閭=>"闾", 閲=>"阅", 閶=>"阊", 閹=>"阉",
	閻=>"阎", 閼=>"阏", 閽=>"阍", 閾=>"阈", 閿=>"阌", 闃=>"阒",
	闆=>"板", 闈=>"闱", 闊=>"阔", 闋=>"阕", 闌=>"阑", 闐=>"阗",
	闔=>"阖", 闕=>"阙", 闖=>"闯", 關=>"关", 闞=>"阚", 闡=>"阐",
	闢=>"辟", 闥=>"闼", 陘=>"陉", 陝=>"陕", 陣=>"阵", 陰=>"阴",
	陳=>"陈", 陸=>"陆", 陽=>"阳", 隉=>"陧", 隊=>"队", 階=>"阶",
	隕=>"陨", 際=>"际", 隨=>"随", 險=>"险", 隱=>"隐", 隴=>"陇",
	隸=>"隶", 雖=>"虽", 雙=>"双", 雛=>"雏", 雜=>"杂", 雞=>"鸡",
	離=>"离", 難=>"难", 雲=>"云", 電=>"电", 霧=>"雾", 霽=>"霁",
	靂=>"雳", 靄=>"霭", 靈=>"灵", 靚=>"靓", 靜=>"静", 靨=>"靥",
	鞏=>"巩", 鞦=>"秋", 鞽=>"鞒", 韃=>"鞑", 韆=>"千", 韉=>"鞯",
	韋=>"韦", 韌=>"韧", 韓=>"韩", 韙=>"韪", 韜=>"韬", 韞=>"韫",
	響=>"响", 頁=>"页", 頂=>"顶", 頃=>"顷", 項=>"项", 順=>"顺",
	頇=>"顸", 須=>"须", 頊=>"顼", 頌=>"颂", 頎=>"颀", 頏=>"颃",
	預=>"预", 頑=>"顽", 頒=>"颁", 頓=>"顿", 頗=>"颇", 領=>"领",
	頜=>"颌", 頡=>"颉", 頤=>"颐", 頦=>"颏", 頭=>"头", 頰=>"颊",
	頷=>"颔", 頸=>"颈", 頻=>"频", 頽=>"颓", 顆=>"颗", 題=>"题",
	額=>"额", 顎=>"颚", 顓=>"颛", 顔=>"颜", 願=>"愿", 顙=>"颡",
	顛=>"颠", 類=>"类", 顢=>"颟", 顥=>"颢", 顧=>"顾", 顫=>"颤",
	顬=>"颥", 顯=>"显", 顱=>"颅", 顳=>"颞", 顴=>"颧", 風=>"风",
	颮=>"飑", 颯=>"飒", 颱=>"台", 颳=>"刮", 颶=>"飓", 颼=>"飕",
	飄=>"飘", 飆=>"飙", 飈=>"飚", 飠=>"饣", 飩=>"饨", 飪=>"饪",
	飫=>"饫", 飭=>"饬", 飯=>"饭", 飲=>"饮", 飴=>"饴", 飼=>"饲",
	飽=>"饱", 飾=>"饰", 餃=>"饺", 餅=>"饼", 餉=>"饷", 養=>"养",
	餌=>"饵", 餑=>"饽", 餒=>"馁", 餓=>"饿", 餘=>"余", 餛=>"馄",
	餞=>"饯", 餡=>"馅", 館=>"馆", 餳=>"饧", 餷=>"馇", 餼=>"饩",
	餾=>"馏", 餿=>"馊", 饃=>"馍", 饅=>"馒", 饈=>"馐", 饉=>"馑",
	饊=>"馓", 饋=>"馈", 饌=>"馔", 饑=>"饥", 饒=>"饶", 饗=>"飨",
	饜=>"餍", 饞=>"馋", 饢=>"馕", 馬=>"马", 馭=>"驭", 馮=>"冯",
	馱=>"驮", 馳=>"驰", 馴=>"驯", 駁=>"驳", 駐=>"驻", 駑=>"驽",
	駒=>"驹", 駔=>"驵", 駕=>"驾", 駘=>"骀", 駙=>"驸", 駛=>"驶",
	駝=>"驼", 駟=>"驷", 駡=>"骂", 駢=>"骈", 駭=>"骇", 駱=>"骆",
	駿=>"骏", 騁=>"骋", 騅=>"骓", 騍=>"骒", 騎=>"骑", 騏=>"骐",
	騖=>"骛", 騙=>"骗", 騫=>"骞", 騭=>"骘", 騮=>"骝", 騰=>"腾",
	騶=>"驺", 騷=>"骚", 騸=>"骟", 騾=>"骡", 驀=>"蓦", 驁=>"骜",
	驂=>"骖", 驃=>"骠", 驄=>"骢", 驅=>"驱", 驊=>"骅", 驍=>"骁",
	驏=>"骣", 驕=>"骄", 驗=>"验", 驚=>"惊", 驛=>"驿", 驟=>"骤",
	驢=>"驴", 驤=>"骧", 驥=>"骥", 驪=>"骊", 骯=>"肮", 髏=>"髅",
	髒=>"脏", 體=>"体", 髕=>"髌", 髖=>"髋", 髮=>"发", 鬆=>"松",
	鬍=>"胡", 鬚=>"须", 鬢=>"鬓", 鬥=>"斗", 鬧=>"闹", 鬩=>"阋",
	鬮=>"阄", 鬱=>"郁", 魎=>"魉", 魘=>"魇", 魚=>"鱼", 魯=>"鲁",
	魴=>"鲂", 魷=>"鱿", 鮁=>"鲅", 鮃=>"鲆", 鮎=>"鲇", 鮐=>"鲐",
	鮑=>"鲍", 鮒=>"鲋", 鮚=>"鲒", 鮝=>"鲞", 鮞=>"鲕", 鮪=>"鲔",
	鮫=>"鲛", 鮭=>"鲑", 鮮=>"鲜", 鯀=>"鲧", 鯁=>"鲠", 鯇=>"鲩",
	鯉=>"鲤", 鯊=>"鲨", 鯔=>"鲻", 鯖=>"鲭", 鯛=>"鲷", 鯝=>"鲴",
	鯡=>"鲱", 鯢=>"鲵", 鯤=>"鲲", 鯧=>"鲳", 鯨=>"鲸", 鯪=>"鲮",
	鯫=>"鲰", 鯰=>"鲶", 鯴=>"鲺", 鯽=>"鲫", 鯿=>"鳊", 鰈=>"鲽",
	鰉=>"鳇", 鰍=>"鳅", 鰐=>"鳄", 鰒=>"鳆", 鰓=>"鳃", 鰠=>"鳋",
	鰣=>"鲥", 鰥=>"鳏", 鰨=>"鳎", 鰩=>"鳐", 鰭=>"鳍", 鰱=>"鲢",
	鰲=>"鳌", 鰳=>"鳓", 鰵=>"鳘", 鰷=>"鲦", 鰹=>"鲣", 鰻=>"鳗",
	鰾=>"鳔", 鱅=>"鳙", 鱈=>"鳕", 鱉=>"鳖", 鱒=>"鳟", 鱔=>"鳝",
	鱖=>"鳜", 鱗=>"鳞", 鱘=>"鲟", 鱝=>"鲼", 鱟=>"鲎", 鱧=>"鳢",
	鱭=>"鲚", 鱸=>"鲈", 鱺=>"鲡", 鳥=>"鸟", 鳩=>"鸠", 鳬=>"凫",
	鳳=>"凤", 鳴=>"鸣", 鳶=>"鸢", 鴆=>"鸩", 鴇=>"鸨", 鴉=>"鸦",
	鴕=>"鸵", 鴛=>"鸳", 鴝=>"鸲", 鴟=>"鸱", 鴣=>"鸪", 鴦=>"鸯",
	鴨=>"鸭", 鴯=>"鸸", 鴰=>"鸹", 鴻=>"鸿", 鴿=>"鸽", 鵂=>"鸺",
	鵑=>"鹃", 鵒=>"鹆", 鵓=>"鹁", 鵜=>"鹈", 鵝=>"鹅", 鵠=>"鹄",
	鵡=>"鹉", 鵪=>"鹌", 鵬=>"鹏", 鵯=>"鹎", 鵲=>"鹊", 鶇=>"鸫",
	鶉=>"鹑", 鶓=>"鹋", 鶘=>"鹕", 鶚=>"鹗", 鶥=>"鹛", 鶩=>"鹜",
	鶯=>"莺", 鶴=>"鹤", 鶻=>"鹘", 鶼=>"鹣", 鷀=>"鹚", 鷂=>"鹞",
	鷄=>"鸡", 鷓=>"鹧", 鷗=>"鸥", 鷙=>"鸷", 鷚=>"鹨", 鷥=>"鸶",
	鷦=>"鹪", 鷯=>"鹩", 鷲=>"鹫", 鷳=>"鹇", 鷸=>"鹬", 鷹=>"鹰",
	鷺=>"鹭", 鸌=>"鹱", 鸕=>"鸬", 鸚=>"鹦", 鸛=>"鹳", 鸝=>"鹂",
	鸞=>"鸾", 鹵=>"卤", 鹹=>"咸", 鹺=>"鹾", 鹼=>"硷", 鹽=>"盐",
	麗=>"丽", 麥=>"麦", 麩=>"麸", 麯=>"曲", 麵=>"面", 麼=>"么",
	黌=>"黉", 點=>"点", 黨=>"党", 黲=>"黪", 黴=>"霉", 黷=>"黩",
	黽=>"黾", 黿=>"鼋", 鼉=>"鼍", 鼕=>"冬", 齊=>"齐", 齋=>"斋",
	齏=>"齑", 齒=>"齿", 齔=>"龀", 齙=>"龅", 齜=>"龇", 齟=>"龃",
	齠=>"龆", 齡=>"龄", 齣=>"出", 齦=>"龈", 齪=>"龊", 齬=>"龉",
	齲=>"龋", 齷=>"龌", 龍=>"龙", 龐=>"庞", 龔=>"龚", 龕=>"龛",
	龜=>"龟", 龥=>"吁",
);


our $simplified  = join "", keys %trad; # chars with a traditional equivalent
our $traditional = join "", keys %simp; # chars with a simplified equivalent


sub simple {
    use utf8;
    my($string, $open_bracket, $close_bracket) = @_;
    $open_bracket  = "[" unless defined $open_bracket;
    $close_bracket = "]" unless defined $close_bracket;

    return $string unless $string =~ /(.*\p{InCJKUnifiedIdeographs}.*)/;
    $string = $1; # nasty kludge round perl unicode bug
	
    $string =~ s<([$traditional])>
    <
	local $_ = $simp{$1};
    	die "program error: no simplified equivalent to $1" unless defined $_;
    	(1==length($_) ? $_ : $open_bracket . $_ . $close_bracket);
    >ge;
    return $string;
};


sub trad {
    my($string, $open_bracket, $close_bracket) = @_;
    $open_bracket  = "[" unless defined $open_bracket;
    $close_bracket = "]" unless defined $close_bracket;
    
    return $string unless $string =~ /(.*\p{InCJKUnifiedIdeographs}.*)/;
    $string = $1; # nasty kludge round perl unicode bug

    $string =~ s<([$simplified])>
    <
	my $t = $trad{$1};
	die "program error: no traditional equivalent to $2" unless defined $t;
	(1==length $t ? $t : $open_bracket . $t . $close_bracket);
    >ge;
    return $string;
}


1;

__END__

=head1 NAME

Lingua::ZH::HanConvert - convert between Traditional and Simplified Chinese characters

=head1 SYNOPSIS

    #!perl -lw
    use Lingua::ZH::HanConvert qw(simple trad);
    use utf8;
    
    my $t = "國"; # Traditional symbol for "country", unicode 22283
	# or: my $t = v22283;

    print simple($t); # Simplified "country", 国 (unicode 22269)
    
    $s = "鱼"; # Simplified symbol for "fish", unicode 40060
	# or: $s = v40060;

    print trad($s); # Traditional "fish", 魚 (unicode 39970)

=head1 REQUIRES

Perl 5.6

=head1 DESCRIPTION

In the 1950's, the Chinese government simplified over 2000 Chinese
characters.  Taiwan and Hong Kong still use the traditional characters.
The simplified characters are hard to read if you only know the traditional
ones, and vice-versa.  This module attempts to convert Chinese text between
the two forms, using character-by-character transliteration.

Note that this module only handles text in the Unicode UTF-8 character set.
If you need to convert between the Big5 and GB character sets, then please
look at L<Text::IConv>, or use the C<HanConvert> Perl script which comes
with this module.

C<simple> takes a string, converts any traditional Chinese characters (such
as E<22283>, unicode U+570B, meaning "country") to the corresponding
simplified characters (like E<22269>, unicode U+56FD, also meaning
"country"), and returns the result.  Characters which are not traditional
Chinese do not change.

C<trad> does the reverse; it converts any simplified Chinese characters to
the corresponding traditional characters.  Characters which are not
simplified Chinese do not change.

If a simplified character has two or more corresponding traditional
characters, then it will be replaced by all of them, enclosed in square
brackets.  To use different characters instead of the square brackets, give
them as the second and third arguments to C<trad>.  The same applies where
a traditional character has two or more corresponding simplified forms,
but this happens much more rarely.

=head1 BUGS, LIMITATIONS

B<There may be mistakes in the transliterations>.  A number of data sources
were used to build the transliteration tables, including dictionaries and
the Unicode consortium's Unihan database, but some mappings may be
incorrect or missing.

Some characters which are simplified forms are also traditional forms.  For
example, E<38754>, unicode U+9762, is the simplified form of E<40629>,
unicode U+9EB5, meaning "noodles"; but it is also the character for "face"
in both traditional and simplified writing.  Most character mapping lists
say that simplified E<38754> (U+9762) can correspond to traditional
E<40629> (U+9EB5), but do not mention that simplified E<38754> (U+9762) can
map to traditional E<38754> (U+9762); common sense makes this is obvious to
a human who comes across this character in a text, but not to a computer
program.  To provide this module with that extra information, it has been
assumed that any simplified form which appears in the Big5 character set is
also a traditional form.  In some cases, this assumption may be incorrect.

The transliteration mappings could be improved. Ideally, I'd like to see
the module performing intelligent transliteration of ambiguous characters
based on context, if suitable data sources were available.  See
C<http://www.basistech.com/articles/C2C.html> for a discussion of
transliteration issues.

Some differences in styles of Chinese writing are not related to simplified
characters.  For instance, the mainland Chinese word for "computer" differs
from the word used in Taiwan.  Colloquial Cantonese writing is different
from Mandarin writing, and everyday Cantonese text such as
"E<20322>E<20418>E<21780>E<20418>E<25105>E<13774>" ("is it mine?") contains
characters and phrases which may be unfamiliar to a Mandarin-speaking
reader.  These issues are beyond the scope of this module; analogously, a
module which converted American English spelling into British English
spelling would not change the word "gasoline" into the word "petrol".

The characters in this documentation may not display correctly unless the
program you are reading it with is unicode-aware.

=head1 SEE ALSO

If you just want to convert some text, you might want to use HanConvert, the
Perl script which comes with this module.

=head1 ACKNOWLEDGEMENTS

Much of the data used by this module is taken from the Unicode consortium's
Unihan database, available from C<ftp://ftp.unicode.org>.  Thanks to them
for compiling the data and making it freely available.

=head1 AUTHOR

David Chan <david@sheetmusic.org.uk>

=head1 COPYRIGHT

Copyright (C) 2001, David Chan. All rights reserved. This program is free
software; you can redistribute it and/or modify it under the same terms as
Perl itself.
