NAME
    RISCOS::DrawFile

SYNOPSIS
    A class to manipulate DrawFiles

DESCRIPTION
    `RISCOS::DrawFile' provides a class to manipulate DrawFiles. It
    is derived from `RISCOS::DrawFile::Container' (which provides
    all the really cool methods), and provides the following
    additional methods.

    new [<contents>, [<creator>, [<oldfont>, [<filetype>]]]]

    new <filename>, [<split_function>]
        creates a new DrawFile. If the first argument is `undef' or
        a reference to an array it is taken to be an array of
        objects derived from <RISCOS::DrawFile::Object> which are to
        be used as the contents. Otherwise the first argument is
        passed to `RISCOS::File::load', so *filename* can actually
        be a filehandle, or the file data to use.

        *creator* defaults to `"PerlDraw$VERSION"', which at 12
        characters can cause problems for some drawing programs
        (*e.g.* DrawPlus prior to 2.41). *oldfont* if defined should
        be a reference to an array of fonts found when loading the
        DrawFile and isn't really used, as
        `RISCOS::DrawFile::TextObject' objects each store their own
        font. *filetype* defaults to 0xAFF (DrawFile).

        *split_function* is passed as the second argument to
        `RISCOS::DrawFile::Object::new' for each object found in the
        DrawFile to process the DrawFile object type to extract
        layer information. If defined this should either be a code
        reference, or the string '`+'' to use
        `RISCOS::DrawFile::Common::drawplus_split_type'

    Write <filename>

    Write <filehandle>
        writes the DrawFile to the given filename or filehandle, and
        attempts to set the file's filetype to the type set/returned
        with `FileType'. Calling this Write as a class method will
        write an empty DrawFile:

            Write RISCOS::DrawFile ('DrawFile')    # Write a blank DrawFile
            RISCOS::DrawFile->Write ('DrawFile')   # There's More Than One Way To Do It


    Major
        returns the major version number of this DrawFile, which
        will always be 201. `new' will correctly refuse to load
        DrawFiles with any other major version number.

    Minor [<version>]
        returns the minor version number of this DrawFile. If an
        defined argument is supplied sets the minor verion to this,
        and returns the old value.

    Creator [<creator>]
        returns the creator string for this DrawFile. If an defined
        argument is supplied sets the creator, and returns the old
        value. Creator strings are truncated or padded with spaces
        to give 12 characters when the DrawFile is written out. Note
        that 12 character creator names can cause problems for
        poorly written programs.

    FileType [<filetype>]
        returns the filetype that `Write' will give this file. If
        *filetype* is supplied this value is set, and the old value
        returned. The value is stored verbatim, relying on
        `RISCOS::File::settype' to do any conversion necessary. If
        the filetype is `undef' then `Write' will not attempt to set
        the filetype.

        Note that while `RISCOS::DrawFile' has no problem loading
        Equasor files, the file written out will have the FontTable
        as first object, rather than the tagged empty path that
        Equasor expects, and so Equasor will refuse to recognise the
        file. Regrettably the transparency that `RISCOS::DrawFile'
        by automaticaly tabulating fonts and creating a FontTable
        means that it is not possible for this general purpose class
        to ensure that the FontTable is at a specific loation within
        the file. (Well, not without breaking various other programs
        that wrongly expect the FontTable to be the very first
        object in a file. RTFM carefully.)


BUGS
    Not tested enough. Especially `Pack'

AUTHOR
    Nicholas Clark <nick@unfortu.net>

